/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.structurizr.model.ContainerInstance;
import com.structurizr.model.Element;
import com.structurizr.model.IdGenerator;
import com.structurizr.model.Relationship;
import java.util.HashSet;
import java.util.Set;

public class NormalizedNameIdGenerator
implements IdGenerator {
    private final boolean canonical;
    private Set<String> usedIds = new HashSet<String>();

    public NormalizedNameIdGenerator() {
        this(true);
    }

    public NormalizedNameIdGenerator(boolean canonical) {
        this.canonical = canonical;
    }

    @Override
    public void found(String id) {
        this.usedIds.add(id);
    }

    @Override
    public String generateId(Element element) {
        if (!this.canonical && element instanceof ContainerInstance) {
            ContainerInstance containerInstance = (ContainerInstance)element;
            return this.generateId(containerInstance.getContainerId() + containerInstance.getInstanceId());
        }
        return this.generateId(this.canonical ? element.getCanonicalName() : element.getName());
    }

    @Override
    public String generateId(Relationship relationship) {
        return this.generateId(this.canonical ? relationship.getSource().getCanonicalName() : relationship.getSource().getName(), relationship.getDescription(), this.canonical ? relationship.getDestination().getCanonicalName() : relationship.getDestination().getName());
    }

    private String generateId(String ... terms) {
        StringBuilder sb = new StringBuilder();
        for (String term : terms) {
            if (term == null) continue;
            sb.append(term.replaceAll("[^a-zA-Z0-9]", ""));
        }
        String id = sb.toString();
        if (this.usedIds.contains(id)) {
            throw new IllegalArgumentException("Non-unique ID generated: " + id);
        }
        this.usedIds.add(id);
        return id;
    }
}

