/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ComponentView
extends StaticView {
    private Container container;
    private String containerId;

    ComponentView() {
    }

    ComponentView(Container container, String key, String description) {
        super(container.getSoftwareSystem(), key, description);
        this.container = container;
    }

    public String getContainerId() {
        if (this.container != null) {
            return this.container.getId();
        }
        return this.containerId;
    }

    void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @JsonIgnore
    public Container getContainer() {
        return this.container;
    }

    void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public void add(@Nonnull SoftwareSystem softwareSystem) {
        if (softwareSystem != null && !softwareSystem.equals(this.getSoftwareSystem())) {
            this.addElement(softwareSystem, true);
        }
    }

    public void addAllContainers() {
        this.getSoftwareSystem().getContainers().forEach(this::add);
    }

    public void add(Container container) {
        if (container != null && !container.equals(this.getContainer())) {
            this.addElement(container, true);
        }
    }

    public void addAllComponents() {
        this.container.getComponents().forEach(this::add);
    }

    public void add(Component component) {
        if (component != null) {
            if (!component.getContainer().equals(this.getContainer())) {
                throw new IllegalArgumentException("Only components belonging to " + this.container.getName() + " can be added to this view.");
            }
            this.addElement(component, true);
        }
    }

    public void remove(Container container) {
        this.removeElement(container);
    }

    public void remove(Component component) {
        this.removeElement(component);
    }

    @Override
    public String getName() {
        return this.getSoftwareSystem().getName() + " - " + this.getContainer().getName() + " - Components";
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
        this.addAllContainers();
        this.addAllComponents();
    }

    @Override
    public void addNearestNeighbours(@Nonnull Element element) {
        super.addNearestNeighbours(element, SoftwareSystem.class);
        super.addNearestNeighbours(element, Person.class);
        super.addNearestNeighbours(element, Container.class);
        super.addNearestNeighbours(element, Component.class);
    }

    public void addExternalDependencies() {
        HashSet<Element> components = new HashSet<Element>();
        this.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Component).forEach(components::add);
        for (Relationship relationship : this.getContainer().getModel().getRelationships()) {
            if (components.contains(relationship.getSource())) {
                this.addExternalDependency(relationship.getDestination(), components);
            }
            if (!components.contains(relationship.getDestination())) continue;
            this.addExternalDependency(relationship.getSource(), components);
        }
        this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> !components.contains(r.getSource()) && !components.contains(r.getDestination())).forEach(this::remove);
    }

    private void addExternalDependency(Element element, Set<Element> components) {
        if (element instanceof Component) {
            if (element.getParent().equals(this.getContainer())) {
                return;
            }
            element = element.getParent();
        }
        if (element instanceof Container) {
            if (element.getParent().equals(this.getContainer().getParent())) {
                this.addElement(element, true);
                return;
            }
            element = element.getParent();
        }
        if (element instanceof SoftwareSystem || element instanceof Person) {
            this.addElement(element, true);
        }
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }
}

