/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.structurizr.model.Relationship;
import com.structurizr.view.Routing;
import com.structurizr.view.Vertex;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public final class RelationshipView {
    private static final int START_OF_LINE = 0;
    private static final int END_OF_LINE = 100;
    private Relationship relationship;
    private String id;
    private String description;
    private String order;
    private Boolean response;
    private Set<Vertex> vertices = new LinkedHashSet<Vertex>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Routing routing;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer position;

    RelationshipView() {
    }

    RelationshipView(Relationship relationship) {
        this.relationship = relationship;
    }

    public String getId() {
        if (this.relationship != null) {
            return this.relationship.getId();
        }
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public Relationship getRelationship() {
        return this.relationship;
    }

    void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrder() {
        return this.order != null ? this.order : "";
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Boolean isResponse() {
        return this.response;
    }

    void setResponse(Boolean response) {
        this.response = response;
    }

    public Collection<Vertex> getVertices() {
        return new LinkedList<Vertex>(this.vertices);
    }

    public void setVertices(Collection<Vertex> vertices) {
        if (vertices != null) {
            this.vertices = new LinkedHashSet<Vertex>(vertices);
        }
    }

    public Routing getRouting() {
        return this.routing;
    }

    public void setRouting(Routing routing) {
        this.routing = routing;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position == null ? null : (position < 0 ? Integer.valueOf(0) : (position > 100 ? Integer.valueOf(100) : position));
    }

    void copyLayoutInformationFrom(RelationshipView source) {
        if (source != null) {
            this.setVertices(source.getVertices());
            this.setPosition(source.getPosition());
            this.setRouting(source.getRouting());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipView that = (RelationshipView)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        return !(this.order != null ? !this.order.equals(that.order) : that.order != null);
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.relationship != null) {
            return (this.order != null ? this.order + ": " : "") + (this.description != null ? this.description + " " : "") + this.relationship.toString();
        }
        return "";
    }
}

