/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.util;

import com.structurizr.util.StringUtils;
import com.structurizr.util.Url;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static String getContentType(@Nonnull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("A file must be specified.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getCanonicalPath() + " does not exist.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getCanonicalPath() + " is not a file.");
        }
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null || !contentType.startsWith("image/")) {
            throw new IllegalArgumentException(file.getCanonicalPath() + " is not a supported image file.");
        }
        return contentType;
    }

    public static String getImageAsBase64(@Nonnull File file) throws IOException {
        String contentType = ImageUtils.getContentType(file);
        BufferedImage bufferedImage = ImageIO.read(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, contentType.split("/")[1], bos);
        byte[] imageBytes = bos.toByteArray();
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    public static String getImageAsDataUri(File file) throws IOException {
        String contentType = ImageUtils.getContentType(file);
        String base64Content = ImageUtils.getImageAsBase64(file);
        return "data:" + contentType + ";base64," + base64Content;
    }

    public static void validateImage(String imageDescriptor) {
        if (StringUtils.isNullOrEmpty(imageDescriptor)) {
            return;
        }
        if (Url.isUrl(imageDescriptor = imageDescriptor.trim())) {
            return;
        }
        if (imageDescriptor.toLowerCase().endsWith(".png") || imageDescriptor.toLowerCase().endsWith(".jpg") || imageDescriptor.toLowerCase().endsWith(".jpeg") || imageDescriptor.toLowerCase().endsWith(".gif")) {
            return;
        }
        if (imageDescriptor.startsWith("data:image")) {
            if (ImageUtils.isSupportedDataUri(imageDescriptor)) {
                return;
            }
            throw new IllegalArgumentException("Only PNG and JPG data URIs are supported: " + imageDescriptor);
        }
        throw new IllegalArgumentException("Expected a URL or data URI");
    }

    public static boolean isSupportedDataUri(String uri) {
        return uri.startsWith("data:image/png;base64,") || uri.startsWith("data:image/jpeg;base64,");
    }
}

