/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.WorkspaceValidationException;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DefaultImpliedRelationshipsStrategy;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Enterprise;
import com.structurizr.model.IdGenerator;
import com.structurizr.model.ImpliedRelationshipsStrategy;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Location;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SequentialIntegerIdGeneratorStrategy;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.model.StaticStructureElementInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Model {
    private IdGenerator idGenerator = new SequentialIntegerIdGeneratorStrategy();
    private final Map<String, Element> elementsById = new HashMap<String, Element>();
    private final Map<String, Relationship> relationshipsById = new HashMap<String, Relationship>();
    private Enterprise enterprise;
    private Set<Person> people = new LinkedHashSet<Person>();
    private Set<SoftwareSystem> softwareSystems = new LinkedHashSet<SoftwareSystem>();
    private Set<DeploymentNode> deploymentNodes = new LinkedHashSet<DeploymentNode>();
    private Set<CustomElement> customElements = new LinkedHashSet<CustomElement>();
    private ImpliedRelationshipsStrategy impliedRelationshipsStrategy = new DefaultImpliedRelationshipsStrategy();

    Model() {
    }

    public Enterprise getEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(Enterprise enterprise) {
        this.enterprise = enterprise;
    }

    public SoftwareSystem addSoftwareSystem(@Nonnull String name) {
        return this.addSoftwareSystem(name, "");
    }

    public SoftwareSystem addSoftwareSystem(@Nonnull String name, @Nullable String description) {
        return this.addSoftwareSystem(Location.Unspecified, name, description);
    }

    @Nonnull
    public SoftwareSystem addSoftwareSystem(@Nullable Location location, @Nonnull String name, @Nullable String description) {
        if (this.getSoftwareSystemWithName(name) == null) {
            SoftwareSystem softwareSystem = new SoftwareSystem();
            softwareSystem.setLocation(location);
            softwareSystem.setName(name);
            softwareSystem.setDescription(description);
            this.softwareSystems.add(softwareSystem);
            softwareSystem.setId(this.idGenerator.generateId(softwareSystem));
            this.addElementToInternalStructures(softwareSystem);
            return softwareSystem;
        }
        throw new IllegalArgumentException("A top-level element named '" + name + "' already exists.");
    }

    @Nonnull
    public Person addPerson(@Nonnull String name) {
        return this.addPerson(name, "");
    }

    @Nonnull
    public Person addPerson(@Nonnull String name, @Nullable String description) {
        return this.addPerson(Location.Unspecified, name, description);
    }

    @Nonnull
    public Person addPerson(Location location, @Nonnull String name, @Nullable String description) {
        if (this.getPersonWithName(name) == null) {
            Person person = new Person();
            person.setLocation(location);
            person.setName(name);
            person.setDescription(description);
            this.people.add(person);
            person.setId(this.idGenerator.generateId(person));
            this.addElementToInternalStructures(person);
            return person;
        }
        throw new IllegalArgumentException("A top-level element named '" + name + "' already exists.");
    }

    @Nonnull
    public CustomElement addCustomElement(@Nonnull String name) {
        return this.addCustomElement(name, "", "");
    }

    @Nonnull
    public CustomElement addCustomElement(@Nonnull String name, @Nullable String metadata, @Nullable String description) {
        if (this.getCustomElementWithName(name) == null) {
            CustomElement customElement = new CustomElement();
            customElement.setName(name);
            customElement.setMetadata(metadata);
            customElement.setDescription(description);
            this.customElements.add(customElement);
            customElement.setId(this.idGenerator.generateId(customElement));
            this.addElementToInternalStructures(customElement);
            return customElement;
        }
        throw new IllegalArgumentException("A top-level element named '" + name + "' already exists.");
    }

    @Nonnull
    Container addContainer(SoftwareSystem parent, @Nonnull String name, @Nullable String description, @Nullable String technology) {
        if (parent.getContainerWithName(name) == null) {
            Container container = new Container();
            container.setName(name);
            container.setDescription(description);
            container.setTechnology(technology);
            container.setParent(parent);
            parent.add(container);
            container.setId(this.idGenerator.generateId(container));
            this.addElementToInternalStructures(container);
            return container;
        }
        throw new IllegalArgumentException("A container named '" + name + "' already exists for this software system.");
    }

    Component addComponentOfType(Container parent, String name, String type, String description, String technology) {
        if (parent.getComponentWithName(name) == null) {
            Component component = new Component();
            component.setName(name);
            component.setDescription(description);
            component.setTechnology(technology);
            if (type != null && type.trim().length() > 0) {
                component.setType(type);
            }
            component.setParent(parent);
            parent.add(component);
            component.setId(this.idGenerator.generateId(component));
            this.addElementToInternalStructures(component);
            return component;
        }
        throw new IllegalArgumentException("A component named '" + name + "' already exists for this container.");
    }

    @Nullable
    Relationship addRelationship(Element source, @Nonnull Element destination, String description, String technology, boolean createImpliedRelationships) {
        return this.addRelationship(source, destination, description, technology, null, new String[0], createImpliedRelationships);
    }

    @Nullable
    Relationship addRelationship(Element source, @Nonnull Element destination, String description, String technology, InteractionStyle interactionStyle) {
        return this.addRelationship(source, destination, description, technology, interactionStyle, new String[0], true);
    }

    @Nullable
    Relationship addRelationship(Element source, @Nonnull Element destination, String description, String technology, InteractionStyle interactionStyle, String[] tags) {
        return this.addRelationship(source, destination, description, technology, interactionStyle, tags, true);
    }

    @Nullable
    Relationship addRelationship(Element source, @Nonnull Element destination, String description, String technology, InteractionStyle interactionStyle, String[] tags, boolean createImpliedRelationships) {
        if (destination == null) {
            throw new IllegalArgumentException("The destination must be specified.");
        }
        if (this.isChildOf(source, destination) || this.isChildOf(destination, source)) {
            throw new IllegalArgumentException("Relationships cannot be added between parents and children.");
        }
        Relationship relationship = new Relationship(source, destination, description, technology, interactionStyle, tags);
        if (this.addRelationship(relationship)) {
            if (createImpliedRelationships && (source instanceof CustomElement || source instanceof Person || source instanceof SoftwareSystem || source instanceof Container || source instanceof Component) && (destination instanceof CustomElement || destination instanceof Person || destination instanceof SoftwareSystem || destination instanceof Container || destination instanceof Component)) {
                this.impliedRelationshipsStrategy.createImpliedRelationships(relationship);
            }
            return relationship;
        }
        return null;
    }

    private boolean isChildOf(Element e1, Element e2) {
        if (e1 instanceof Person || e2 instanceof Person) {
            return false;
        }
        for (Element parent = e2.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getId().equals(e1.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean addRelationship(Relationship relationship) {
        if (!relationship.getSource().has(relationship)) {
            relationship.setId(this.idGenerator.generateId(relationship));
            relationship.getSource().addRelationship(relationship);
            this.addRelationshipToInternalStructures(relationship);
            return true;
        }
        return false;
    }

    private void addElementToInternalStructures(Element element) {
        if (this.getElement(element.getId()) != null || this.getRelationship(element.getId()) != null) {
            throw new WorkspaceValidationException("The element " + element.getCanonicalName() + " has a non-unique ID of " + element.getId() + ".");
        }
        this.elementsById.put(element.getId(), element);
        element.setModel(this);
        this.idGenerator.found(element.getId());
    }

    private void addRelationshipToInternalStructures(Relationship relationship) {
        if (this.getElement(relationship.getId()) != null || this.getRelationship(relationship.getId()) != null) {
            throw new WorkspaceValidationException("The relationship " + relationship.toString() + " has a non-unique ID of " + relationship.getId() + ".");
        }
        this.relationshipsById.put(relationship.getId(), relationship);
        relationship.setModel(this);
        this.idGenerator.found(relationship.getId());
    }

    @JsonIgnore
    @Nonnull
    public Set<Element> getElements() {
        return new HashSet<Element>(this.elementsById.values());
    }

    @Nullable
    public Element getElement(@Nonnull String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("An element ID must be specified.");
        }
        return this.elementsById.get(id);
    }

    @JsonIgnore
    @Nonnull
    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(this.relationshipsById.values());
    }

    @Nullable
    public Relationship getRelationship(@Nonnull String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("A relationship ID must be specified.");
        }
        return this.relationshipsById.get(id);
    }

    @Nonnull
    public Set<CustomElement> getCustomElements() {
        return new LinkedHashSet<CustomElement>(this.customElements);
    }

    void setCustomElements(Set<CustomElement> customElements) {
        if (customElements != null) {
            this.customElements = new LinkedHashSet<CustomElement>(customElements);
        }
    }

    @Nonnull
    public Set<Person> getPeople() {
        return new LinkedHashSet<Person>(this.people);
    }

    void setPeople(Set<Person> people) {
        if (people != null) {
            this.people = new LinkedHashSet<Person>(people);
        }
    }

    @Nonnull
    public Set<SoftwareSystem> getSoftwareSystems() {
        return new LinkedHashSet<SoftwareSystem>(this.softwareSystems);
    }

    void setSoftwareSystems(Set<SoftwareSystem> softwareSystems) {
        if (softwareSystems != null) {
            this.softwareSystems = new LinkedHashSet<SoftwareSystem>(softwareSystems);
        }
    }

    @Nonnull
    public Set<DeploymentNode> getDeploymentNodes() {
        return new LinkedHashSet<DeploymentNode>(this.deploymentNodes);
    }

    void setDeploymentNodes(Set<DeploymentNode> deploymentNodes) {
        if (deploymentNodes != null) {
            this.deploymentNodes = new LinkedHashSet<DeploymentNode>(deploymentNodes);
        }
    }

    void hydrate() {
        this.customElements.forEach(this::addElementToInternalStructures);
        this.people.forEach(this::addElementToInternalStructures);
        for (SoftwareSystem softwareSystem : this.softwareSystems) {
            this.addElementToInternalStructures(softwareSystem);
            for (Container container : softwareSystem.getContainers()) {
                this.addElementToInternalStructures(container);
                container.setParent(softwareSystem);
                for (Component component : container.getComponents()) {
                    this.addElementToInternalStructures(component);
                    component.setParent(container);
                }
            }
        }
        this.deploymentNodes.forEach(dn -> this.hydrateDeploymentNode((DeploymentNode)dn, null));
        this.getElements().forEach(this::hydrateRelationships);
        ArrayList<StaticStructureElement> peopleAndSoftwareSystems = new ArrayList<StaticStructureElement>();
        peopleAndSoftwareSystems.addAll(this.people);
        peopleAndSoftwareSystems.addAll(this.softwareSystems);
        for (Element element : peopleAndSoftwareSystems) {
            this.checkNameIsUnique(peopleAndSoftwareSystems, element.getName(), "A person or software system named \"%s\" already exists.");
        }
        for (SoftwareSystem softwareSystem : this.softwareSystems) {
            for (Container container : softwareSystem.getContainers()) {
                this.checkNameIsUnique(softwareSystem.getContainers(), container.getName(), "A container named \"%s\" already exists within \"" + softwareSystem.getName() + "\".");
                for (Component component : container.getComponents()) {
                    this.checkNameIsUnique(container.getComponents(), component.getName(), "A component named \"%s\" already exists within \"" + container.getName() + "\".");
                }
            }
        }
        for (DeploymentNode deploymentNode : this.deploymentNodes) {
            this.checkNameIsUnique(this.deploymentNodes, deploymentNode.getName(), deploymentNode.getEnvironment(), "A top-level deployment node named \"%s\" already exists for the environment named \"" + deploymentNode.getEnvironment() + "\".");
            if (!deploymentNode.hasChildren()) continue;
            this.checkChildNamesAreUnique(deploymentNode);
        }
        for (Element element : this.getElements()) {
            for (Relationship relationship : element.getRelationships()) {
                this.checkDescriptionIsUnique(element.getRelationships(), relationship);
            }
        }
    }

    private void hydrateDeploymentNode(DeploymentNode deploymentNode, DeploymentNode parent) {
        deploymentNode.setParent(parent);
        this.addElementToInternalStructures(deploymentNode);
        deploymentNode.getChildren().forEach(child -> this.hydrateDeploymentNode((DeploymentNode)child, deploymentNode));
        for (SoftwareSystemInstance softwareSystemInstance : deploymentNode.getSoftwareSystemInstances()) {
            Element softwareSystem = this.getElement(softwareSystemInstance.getSoftwareSystemId());
            if (!(softwareSystem instanceof SoftwareSystem)) {
                throw new WorkspaceValidationException(String.format("A software system instance is associated with a software system (id=%s) that does not exist in the model.", softwareSystemInstance.getSoftwareSystemId()));
            }
            softwareSystemInstance.setSoftwareSystem((SoftwareSystem)softwareSystem);
            softwareSystemInstance.setParent(deploymentNode);
            this.addElementToInternalStructures(softwareSystemInstance);
        }
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            Element container = this.getElement(containerInstance.getContainerId());
            if (!(container instanceof Container)) {
                throw new WorkspaceValidationException(String.format("A container instance is associated with a container (id=%s) that does not exist in the model.", containerInstance.getContainerId()));
            }
            containerInstance.setContainer((Container)container);
            containerInstance.setParent(deploymentNode);
            this.addElementToInternalStructures(containerInstance);
        }
        for (InfrastructureNode infrastructureNode : deploymentNode.getInfrastructureNodes()) {
            infrastructureNode.setParent(deploymentNode);
            this.addElementToInternalStructures(infrastructureNode);
        }
    }

    private void checkNameIsUnique(Collection<? extends Element> elements, String name, String errorMessage) {
        if (elements.stream().filter(e -> e.getName().equals(name)).count() != 1L) {
            throw new WorkspaceValidationException(String.format(errorMessage, name));
        }
    }

    private void checkNameIsUnique(Collection<DeploymentNode> deploymentNodes, String name, String environment, String errorMessage) {
        if (deploymentNodes.stream().filter(dn -> dn.getName().equals(name) && dn.getEnvironment().equals(environment)).count() != 1L) {
            throw new WorkspaceValidationException(String.format(errorMessage, name));
        }
    }

    private void checkChildNamesAreUnique(DeploymentNode deploymentNode) {
        for (DeploymentNode child : deploymentNode.getChildren()) {
            this.checkNameIsUnique(deploymentNode.getChildren(), child.getName(), deploymentNode.getEnvironment(), "A deployment node named \"%s\" already exists within \"" + deploymentNode.getName() + "\".");
            if (!child.hasChildren()) continue;
            this.checkChildNamesAreUnique(child);
        }
    }

    private void checkDescriptionIsUnique(Collection<Relationship> relationships, Relationship relationship) {
        if (relationships.stream().filter(r -> r.getDestination().equals(relationship.getDestination()) && r.getDescription().equals(relationship.getDescription())).count() != 1L) {
            throw new WorkspaceValidationException(String.format("A relationship with the description \"%s\" already exists between \"%s\" and \"%s\".", relationship.getDescription(), relationship.getSource().getName(), relationship.getDestination().getName()));
        }
    }

    private void hydrateRelationships(Element element) {
        for (Relationship relationship : element.getRelationships()) {
            relationship.setSource(this.getElement(relationship.getSourceId()));
            relationship.setDestination(this.getElement(relationship.getDestinationId()));
            this.addRelationshipToInternalStructures(relationship);
        }
    }

    public boolean contains(Element element) {
        return this.elementsById.values().contains(element);
    }

    @Nullable
    public SoftwareSystem getSoftwareSystemWithName(@Nonnull String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A software system name must be specified.");
        }
        for (SoftwareSystem softwareSystem : this.getSoftwareSystems()) {
            if (!softwareSystem.getName().equals(name)) continue;
            return softwareSystem;
        }
        return null;
    }

    @Nullable
    public SoftwareSystem getSoftwareSystemWithId(@Nonnull String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("A software system ID must be specified.");
        }
        for (SoftwareSystem softwareSystem : this.getSoftwareSystems()) {
            if (!softwareSystem.getId().equals(id)) continue;
            return softwareSystem;
        }
        return null;
    }

    @Nullable
    public Person getPersonWithName(@Nonnull String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A person name must be specified.");
        }
        for (Person person : this.getPeople()) {
            if (!person.getName().equals(name)) continue;
            return person;
        }
        return null;
    }

    @Nullable
    public CustomElement getCustomElementWithName(@Nonnull String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A custom element name must be specified.");
        }
        for (CustomElement customElement : this.getCustomElements()) {
            if (!customElement.getName().equals(name)) continue;
            return customElement;
        }
        return null;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.people.isEmpty() && this.softwareSystems.isEmpty() && this.deploymentNodes.isEmpty();
    }

    @Nonnull
    public DeploymentNode addDeploymentNode(@Nonnull String name) {
        return this.addDeploymentNode("Default", name, null, null);
    }

    @Nonnull
    public DeploymentNode addDeploymentNode(@Nonnull String name, @Nullable String description, @Nullable String technology) {
        return this.addDeploymentNode("Default", name, description, technology);
    }

    @Nonnull
    public DeploymentNode addDeploymentNode(@Nullable String environment, @Nonnull String name, @Nullable String description, @Nullable String technology) {
        return this.addDeploymentNode(environment, name, description, technology, 1);
    }

    @Nonnull
    public DeploymentNode addDeploymentNode(@Nonnull String name, @Nullable String description, @Nullable String technology, int instances) {
        return this.addDeploymentNode("Default", name, description, technology, instances);
    }

    @Nonnull
    public DeploymentNode addDeploymentNode(@Nullable String environment, @Nonnull String name, @Nullable String description, @Nullable String technology, int instances) {
        return this.addDeploymentNode(environment, name, description, technology, instances, null);
    }

    @Nonnull
    public DeploymentNode addDeploymentNode(@Nonnull String name, String description, String technology, int instances, Map<String, String> properties) {
        return this.addDeploymentNode("Default", name, description, technology, instances, properties);
    }

    @Nonnull
    public DeploymentNode addDeploymentNode(@Nullable String environment, @Nonnull String name, String description, String technology, int instances, Map<String, String> properties) {
        return this.addDeploymentNode(null, environment, name, description, technology, instances, properties);
    }

    @Nonnull
    DeploymentNode addDeploymentNode(DeploymentNode parent, @Nullable String environment, @Nonnull String name, String description, String technology, int instances, Map<String, String> properties) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        if (parent == null && this.getDeploymentNodeWithName(name, environment) == null || parent != null && parent.getDeploymentNodeWithName(name) == null && parent.getInfrastructureNodeWithName(name) == null) {
            DeploymentNode deploymentNode = new DeploymentNode();
            deploymentNode.setName(name);
            deploymentNode.setDescription(description);
            deploymentNode.setTechnology(technology);
            deploymentNode.setParent(parent);
            deploymentNode.setInstances(instances);
            deploymentNode.setEnvironment(environment);
            if (properties != null) {
                deploymentNode.setProperties(properties);
            }
            if (parent == null) {
                this.deploymentNodes.add(deploymentNode);
            }
            deploymentNode.setId(this.idGenerator.generateId(deploymentNode));
            this.addElementToInternalStructures(deploymentNode);
            return deploymentNode;
        }
        throw new IllegalArgumentException("A deployment/infrastructure node named '" + name + "' already exists.");
    }

    @Nonnull
    InfrastructureNode addInfrastructureNode(DeploymentNode parent, @Nonnull String name, String description, String technology, Map<String, String> properties) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        if (parent.getDeploymentNodeWithName(name) == null && parent.getInfrastructureNodeWithName(name) == null) {
            InfrastructureNode infrastructureNode = new InfrastructureNode();
            infrastructureNode.setName(name);
            infrastructureNode.setDescription(description);
            infrastructureNode.setTechnology(technology);
            infrastructureNode.setParent(parent);
            infrastructureNode.setEnvironment(parent.getEnvironment());
            if (properties != null) {
                infrastructureNode.setProperties(properties);
            }
            infrastructureNode.setId(this.idGenerator.generateId(infrastructureNode));
            this.addElementToInternalStructures(infrastructureNode);
            return infrastructureNode;
        }
        throw new IllegalArgumentException("A deployment/infrastructure node named '" + name + "' already exists.");
    }

    public DeploymentNode getDeploymentNodeWithName(String name) {
        return this.getDeploymentNodeWithName(name, "Default");
    }

    public DeploymentNode getDeploymentNodeWithName(String name, String environment) {
        for (DeploymentNode deploymentNode : this.getDeploymentNodes()) {
            if (!deploymentNode.getEnvironment().equals(environment) || !deploymentNode.getName().equals(name)) continue;
            return deploymentNode;
        }
        return null;
    }

    SoftwareSystemInstance addSoftwareSystemInstance(DeploymentNode deploymentNode, SoftwareSystem softwareSystem, String ... deploymentGroups) {
        if (softwareSystem == null) {
            throw new IllegalArgumentException("A software system must be specified.");
        }
        long instanceNumber = deploymentNode.getSoftwareSystemInstances().stream().filter(ssi -> ssi.getSoftwareSystem().equals(softwareSystem)).count();
        SoftwareSystemInstance softwareSystemInstance = new SoftwareSystemInstance(softwareSystem, (int)(++instanceNumber), deploymentNode.getEnvironment(), deploymentGroups);
        softwareSystemInstance.setParent(deploymentNode);
        softwareSystemInstance.setId(this.idGenerator.generateId(softwareSystemInstance));
        this.replicateElementRelationships(softwareSystemInstance);
        this.addElementToInternalStructures(softwareSystemInstance);
        return softwareSystemInstance;
    }

    ContainerInstance addContainerInstance(DeploymentNode deploymentNode, Container container, String ... deploymentGroups) {
        if (container == null) {
            throw new IllegalArgumentException("A container must be specified.");
        }
        long instanceNumber = deploymentNode.getContainerInstances().stream().filter(ci -> ci.getContainer().equals(container)).count();
        ContainerInstance containerInstance = new ContainerInstance(container, (int)(++instanceNumber), deploymentNode.getEnvironment(), deploymentGroups);
        containerInstance.setParent(deploymentNode);
        containerInstance.setId(this.idGenerator.generateId(containerInstance));
        this.replicateElementRelationships(containerInstance);
        this.addElementToInternalStructures(containerInstance);
        return containerInstance;
    }

    private void replicateElementRelationships(StaticStructureElementInstance elementInstance) {
        StaticStructureElement element = elementInstance.getElement();
        Set elementInstances = this.getElements().stream().filter(e -> e instanceof StaticStructureElementInstance).map(e -> (StaticStructureElementInstance)e).filter(ssei -> ssei.getEnvironment().equals(elementInstance.getEnvironment())).filter(ssei -> ssei.inSameDeploymentGroup(elementInstance)).collect(Collectors.toSet());
        for (StaticStructureElementInstance ssei2 : elementInstances) {
            Relationship newRelationship;
            StaticStructureElement sse = ssei2.getElement();
            for (Relationship relationship : element.getRelationships()) {
                if (!relationship.getDestination().equals(sse) || (newRelationship = this.addRelationship((Element)elementInstance, (Element)ssei2, relationship.getDescription(), relationship.getTechnology(), relationship.getInteractionStyle())) == null) continue;
                newRelationship.setTags(null);
                newRelationship.setLinkedRelationshipId(relationship.getId());
            }
            for (Relationship relationship : sse.getRelationships()) {
                if (!relationship.getDestination().equals(element) || (newRelationship = this.addRelationship((Element)ssei2, (Element)elementInstance, relationship.getDescription(), relationship.getTechnology(), relationship.getInteractionStyle())) == null) continue;
                newRelationship.setTags(null);
                newRelationship.setLinkedRelationshipId(relationship.getId());
            }
        }
    }

    public Element getElementWithCanonicalName(String canonicalName) {
        if (canonicalName == null || canonicalName.trim().length() == 0) {
            throw new IllegalArgumentException("A canonical name must be specified.");
        }
        for (Element element : this.getElements()) {
            if (!element.getCanonicalName().equals(canonicalName)) continue;
            return element;
        }
        return null;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        if (idGenerator == null) {
            throw new IllegalArgumentException("An ID generator must be provided.");
        }
        this.idGenerator = idGenerator;
    }

    public void modifyRelationship(Relationship relationship, String description, String technology) {
        if (relationship == null) {
            throw new IllegalArgumentException("A relationship must be specified.");
        }
        if (relationship.getSource().hasEfferentRelationshipWith(relationship.getDestination(), description)) {
            throw new IllegalArgumentException(String.format("A relationship named \"%s\" between \"%s\" and \"%s\" already exists.", description, relationship.getSource().getName(), relationship.getDestination().getName()));
        }
        relationship.setDescription(description);
        relationship.setTechnology(technology);
    }

    @JsonIgnore
    public ImpliedRelationshipsStrategy getImpliedRelationshipsStrategy() {
        return this.impliedRelationshipsStrategy;
    }

    public void setImpliedRelationshipsStrategy(ImpliedRelationshipsStrategy impliedRelationshipStrategy) {
        this.impliedRelationshipsStrategy = impliedRelationshipStrategy != null ? impliedRelationshipStrategy : new DefaultImpliedRelationshipsStrategy();
    }
}

