/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CodeElementRole;
import com.structurizr.util.Url;

public final class CodeElement {
    private CodeElementRole role = CodeElementRole.Supporting;
    private String name;
    private String type;
    private String description;
    private String url;
    private String language = "Java";
    private String category;
    private String visibility;
    private long size;

    CodeElement() {
    }

    CodeElement(String fullyQualifiedTypeName) {
        if (fullyQualifiedTypeName == null || fullyQualifiedTypeName.trim().isEmpty()) {
            throw new IllegalArgumentException("A fully qualified name must be provided.");
        }
        int dot = fullyQualifiedTypeName.lastIndexOf(46);
        if (dot > -1) {
            this.setName(fullyQualifiedTypeName.substring(dot + 1, fullyQualifiedTypeName.length()));
            this.setType(fullyQualifiedTypeName);
        } else {
            this.setName(fullyQualifiedTypeName);
            this.setType(fullyQualifiedTypeName);
        }
    }

    public CodeElementRole getRole() {
        return this.role;
    }

    void setRole(CodeElementRole role) {
        this.role = role;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public String getPackage() {
        return this.type.substring(0, this.type.lastIndexOf(46));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url != null && url.trim().length() > 0) {
            if (Url.isUrl(url)) {
                this.url = url;
            } else {
                throw new IllegalArgumentException(url + " is not a valid URL.");
            }
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeElement that = (CodeElement)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

