/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Documentation;
import com.structurizr.model.CanonicalNameGenerator;
import com.structurizr.model.Component;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class Container
extends StaticStructureElement
implements Documentable {
    private SoftwareSystem parent;
    private String technology;
    private Set<Component> components = new LinkedHashSet<Component>();
    private Documentation documentation = new Documentation();

    Container() {
    }

    @Override
    @JsonIgnore
    public Element getParent() {
        return this.parent;
    }

    @JsonIgnore
    public SoftwareSystem getSoftwareSystem() {
        return this.parent;
    }

    void setParent(SoftwareSystem parent) {
        this.parent = parent;
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }

    public Component addComponent(String name) {
        return this.addComponent(name, "");
    }

    public Component addComponent(String name, String description) {
        return this.addComponent(name, description, null);
    }

    public Component addComponent(String name, String description, String technology) {
        return this.getModel().addComponent(this, name, description, technology);
    }

    void add(Component component) {
        if (this.getComponentWithName(component.getName()) == null) {
            this.components.add(component);
        }
    }

    public Set<Component> getComponents() {
        return new HashSet<Component>(this.components);
    }

    void setComponents(Set<Component> components) {
        if (components != null) {
            this.components = new HashSet<Component>(components);
        }
    }

    public Component getComponentWithName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A component name must be provided.");
        }
        Optional<Component> component = this.components.stream().filter(c -> name.equals(c.getName())).findFirst();
        return component.orElse(null);
    }

    @Override
    public String getCanonicalName() {
        return new CanonicalNameGenerator().generate(this);
    }

    @Override
    public Set<String> getDefaultTags() {
        return new LinkedHashSet<String>(Arrays.asList("Element", "Container"));
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    void setDocumentation(@Nonnull Documentation documentation) {
        this.documentation = documentation;
    }
}

