/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CustomElement;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Model;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Element
extends ModelItem {
    private Model model;
    private String name;
    private String description;
    private Set<Relationship> relationships = new LinkedHashSet<Relationship>();

    protected Element() {
    }

    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    protected void setModel(Model model) {
        this.model = model;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The name of an element must not be null or empty.");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract Element getParent();

    public Set<Relationship> getRelationships() {
        return new LinkedHashSet<Relationship>(this.relationships);
    }

    void setRelationships(Set<Relationship> relationships) {
        if (relationships != null) {
            this.relationships = new LinkedHashSet<Relationship>(relationships);
        }
    }

    public boolean hasAfferentRelationships() {
        return this.getModel().getRelationships().stream().filter(r -> r.getDestination() == this).count() > 0L;
    }

    public boolean hasEfferentRelationshipWith(Element element) {
        return this.getEfferentRelationshipWith(element) != null;
    }

    public boolean hasEfferentRelationshipWith(Element element, String description) {
        return this.getEfferentRelationshipWith(element, description) != null;
    }

    public Relationship getEfferentRelationshipWith(Element element) {
        if (element == null) {
            return null;
        }
        for (Relationship relationship : this.relationships) {
            if (!relationship.getDestination().equals(element)) continue;
            return relationship;
        }
        return null;
    }

    public Set<Relationship> getEfferentRelationshipsWith(Element element) {
        HashSet<Relationship> set = new HashSet<Relationship>();
        if (element != null) {
            for (Relationship relationship : this.relationships) {
                if (!relationship.getDestination().equals(element)) continue;
                set.add(relationship);
            }
        }
        return set;
    }

    public Relationship getEfferentRelationshipWith(Element element, String description) {
        if (element == null) {
            return null;
        }
        if (description == null) {
            description = "";
        }
        for (Relationship relationship : this.relationships) {
            if (!relationship.getDestination().equals(element) || !description.equals(relationship.getDescription())) continue;
            return relationship;
        }
        return null;
    }

    boolean has(Relationship relationship) {
        return this.relationships.stream().anyMatch(r -> r.getDestination().equals(relationship.getDestination()) && r.getDescription().equals(relationship.getDescription()));
    }

    void addRelationship(Relationship relationship) {
        this.relationships.add(relationship);
    }

    @Nullable
    public Relationship uses(@Nonnull CustomElement destination, String description) {
        return this.uses(destination, description, null);
    }

    @Nullable
    public Relationship uses(@Nonnull CustomElement destination, String description, String technology) {
        return this.getModel().addRelationship(this, (Element)destination, description, technology, null);
    }

    @Nullable
    public Relationship uses(@Nonnull CustomElement destination, String description, String technology, InteractionStyle interactionStyle, String[] tags) {
        return this.getModel().addRelationship(this, destination, description, technology, interactionStyle, tags);
    }

    public String toString() {
        return "{" + this.getId() + " | " + this.getName() + " | " + this.getDescription() + "}";
    }
}

