/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.SequenceNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;

public final class DynamicView
extends ModelView {
    private Model model;
    private Element element;
    private String elementId;
    private boolean externalBoundariesVisible = false;
    private SequenceNumber sequenceNumber = new SequenceNumber();

    DynamicView() {
    }

    DynamicView(Model model, String key, String description) {
        super(null, key, description);
        this.setModel(model);
        this.setElement(null);
    }

    DynamicView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.setModel(softwareSystem.getModel());
        this.setElement(softwareSystem);
    }

    DynamicView(Container container, String key, String description) {
        super(container.getSoftwareSystem(), key, description);
        this.setModel(container.getModel());
        this.setElement(container);
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    @Override
    @JsonIgnore
    public String getSoftwareSystemId() {
        return super.getSoftwareSystemId();
    }

    public String getElementId() {
        if (this.element != null) {
            return this.element.getId();
        }
        return this.elementId;
    }

    void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @JsonIgnore
    public Element getElement() {
        return this.element;
    }

    void setElement(Element element) {
        this.element = element;
        if (element instanceof SoftwareSystem) {
            this.setSoftwareSystem((SoftwareSystem)element);
        }
    }

    public RelationshipView add(@Nonnull StaticStructureElement source, @Nonnull StaticStructureElement destination) {
        return this.add(source, "", destination);
    }

    public RelationshipView add(@Nonnull StaticStructureElement source, String description, @Nonnull StaticStructureElement destination) {
        return this.add(source, description, "", destination);
    }

    public RelationshipView add(@Nonnull StaticStructureElement source, String description, String technology, @Nonnull StaticStructureElement destination) {
        return this.addRelationshipViaElements(source, description, technology, destination);
    }

    public RelationshipView add(@Nonnull CustomElement source, @Nonnull StaticStructureElement destination) {
        return this.add(source, "", destination);
    }

    public RelationshipView add(@Nonnull CustomElement source, String description, @Nonnull StaticStructureElement destination) {
        return this.add(source, description, "", destination);
    }

    public RelationshipView add(@Nonnull CustomElement source, String description, String technology, @Nonnull StaticStructureElement destination) {
        return this.addRelationshipViaElements(source, description, technology, destination);
    }

    public RelationshipView add(@Nonnull StaticStructureElement source, @Nonnull CustomElement destination) {
        return this.add(source, "", destination);
    }

    public RelationshipView add(@Nonnull StaticStructureElement source, String description, @Nonnull CustomElement destination) {
        return this.add(source, description, "", destination);
    }

    public RelationshipView add(@Nonnull StaticStructureElement source, String description, String technology, @Nonnull CustomElement destination) {
        return this.addRelationshipViaElements(source, description, technology, destination);
    }

    public RelationshipView add(@Nonnull CustomElement source, @Nonnull CustomElement destination) {
        return this.add(source, "", destination);
    }

    public RelationshipView add(@Nonnull CustomElement source, String description, @Nonnull CustomElement destination) {
        return this.add(source, description, "", destination);
    }

    public RelationshipView add(@Nonnull CustomElement source, String description, String technology, @Nonnull CustomElement destination) {
        return this.addRelationshipViaElements(source, description, technology, destination);
    }

    private RelationshipView addRelationshipViaElements(@Nonnull Element source, String description, String technology, @Nonnull Element destination) {
        Set<Relationship> relationships;
        if (source == null) {
            throw new IllegalArgumentException("A source element must be specified.");
        }
        if (destination == null) {
            throw new IllegalArgumentException("A destination element must be specified.");
        }
        this.checkElementCanBeAdded(source);
        this.checkElementCanBeAdded(destination);
        Relationship relationship = null;
        if (StringUtils.isNullOrEmpty(technology)) {
            relationship = source.getEfferentRelationshipWith(destination, description);
            if (relationship == null) {
                relationship = source.getEfferentRelationshipWith(destination);
            }
        } else {
            relationships = source.getEfferentRelationshipsWith(destination);
            for (Relationship rel : relationships) {
                if (!technology.equals(rel.getTechnology())) continue;
                relationship = rel;
            }
        }
        if (relationship != null) {
            this.addElement(source, false);
            this.addElement(destination, false);
            return this.addRelationship(relationship, description, this.sequenceNumber.getNext(), false);
        }
        if (StringUtils.isNullOrEmpty(technology)) {
            relationship = destination.getEfferentRelationshipWith(source);
        } else {
            relationships = destination.getEfferentRelationshipsWith(source);
            for (Relationship rel : relationships) {
                if (!technology.equals(rel.getTechnology())) continue;
                relationship = rel;
            }
        }
        if (relationship != null) {
            this.addElement(source, false);
            this.addElement(destination, false);
            return this.addRelationship(relationship, description, this.sequenceNumber.getNext(), true);
        }
        if (StringUtils.isNullOrEmpty(technology)) {
            throw new IllegalArgumentException("A relationship between " + source.getName() + " and " + destination.getName() + " does not exist in model.");
        }
        throw new IllegalArgumentException("A relationship between " + source.getName() + " and " + destination.getName() + " with technology " + technology + " does not exist in model.");
    }

    public RelationshipView add(Relationship relationship) {
        return this.add(relationship, "");
    }

    public RelationshipView add(Relationship relationship, String description) {
        if (relationship == null) {
            throw new IllegalArgumentException("A relationship must be specified.");
        }
        this.checkElementCanBeAdded(relationship.getSource());
        this.checkElementCanBeAdded(relationship.getDestination());
        this.addElement(relationship.getSource(), false);
        this.addElement(relationship.getDestination(), false);
        return this.addRelationship(relationship, description, this.sequenceNumber.getNext(), false);
    }

    protected RelationshipView addRelationship(Relationship relationship, String description, String order, boolean response) {
        RelationshipView relationshipView = this.addRelationship(relationship);
        if (relationshipView != null) {
            relationshipView.setDescription(description);
            relationshipView.setOrder(order);
            relationshipView.setResponse(response);
        }
        return relationshipView;
    }

    @Override
    public String getName() {
        if (this.element != null) {
            return this.element.getName() + " - Dynamic";
        }
        return "Dynamic";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<RelationshipView> list = new ArrayList<RelationshipView>(this.getRelationships());
        Collections.sort(list, (rv1, rv2) -> rv1.getOrder().compareTo(rv2.getOrder()));
        list.forEach(rv -> buf.append(rv.toString() + "\n"));
        return buf.toString();
    }

    public void startParallelSequence() {
        this.sequenceNumber.startParallelSequence();
    }

    public void endParallelSequence() {
        this.endParallelSequence(false);
    }

    public void endParallelSequence(boolean endAllParallelSequencesAndContinueNumbering) {
        this.sequenceNumber.endParallelSequence(endAllParallelSequencesAndContinueNumbering);
    }

    @Override
    protected void checkElementCanBeAdded(Element elementToBeAdded) {
        if (elementToBeAdded instanceof CustomElement) {
            return;
        }
        if (!(elementToBeAdded instanceof StaticStructureElement)) {
            throw new ElementNotPermittedInViewException("Only people, software systems, containers and components can be added to dynamic views.");
        }
        StaticStructureElement staticStructureElementToBeAdded = (StaticStructureElement)elementToBeAdded;
        if (staticStructureElementToBeAdded instanceof Person) {
            return;
        }
        if (this.element instanceof SoftwareSystem) {
            if (staticStructureElementToBeAdded.equals(this.element)) {
                throw new ElementNotPermittedInViewException(staticStructureElementToBeAdded.getName() + " is already the scope of this view and cannot be added to it.");
            }
            if (staticStructureElementToBeAdded instanceof SoftwareSystem || staticStructureElementToBeAdded instanceof Container) {
                this.checkParentAndChildrenHaveNotAlreadyBeenAdded(staticStructureElementToBeAdded);
            } else if (staticStructureElementToBeAdded instanceof Component) {
                throw new ElementNotPermittedInViewException("Components can't be added to a dynamic view when the scope is a software system.");
            }
        }
        if (this.element instanceof Container) {
            if (staticStructureElementToBeAdded.equals(this.element) || staticStructureElementToBeAdded.equals(this.element.getParent())) {
                throw new ElementNotPermittedInViewException(staticStructureElementToBeAdded.getName() + " is already the scope of this view and cannot be added to it.");
            }
            this.checkParentAndChildrenHaveNotAlreadyBeenAdded(staticStructureElementToBeAdded);
        }
        if (this.element == null && !(staticStructureElementToBeAdded instanceof SoftwareSystem)) {
            throw new ElementNotPermittedInViewException("Only people and software systems can be added to this dynamic view.");
        }
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }

    @Override
    public Set<RelationshipView> getRelationships() {
        LinkedList<RelationshipView> list = new LinkedList<RelationshipView>(super.getRelationships());
        boolean ordersAreNumeric = true;
        for (RelationshipView relationshipView : list) {
            ordersAreNumeric = ordersAreNumeric && this.isNumeric(relationshipView.getOrder());
        }
        if (ordersAreNumeric) {
            list.sort(Comparator.comparingDouble(rv -> Double.parseDouble(rv.getOrder())));
        } else {
            list.sort(Comparator.comparing(RelationshipView::getOrder));
        }
        return new LinkedHashSet<RelationshipView>(list);
    }

    private boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean getExternalBoundariesVisible() {
        return this.externalBoundariesVisible;
    }

    @Deprecated
    public void setExternalBoundariesVisible(boolean externalBoundariesVisible) {
        this.externalBoundariesVisible = externalBoundariesVisible;
    }
}

