/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Element;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.StringUtils;
import com.structurizr.view.View;

public final class ImageView
extends View {
    private Element element;
    private String elementId;
    private String content;
    private String contentType;

    ImageView() {
    }

    ImageView(String key) {
        this.setKey(key);
    }

    ImageView(Element element, String key) {
        this(key);
        this.setElement(element);
    }

    public String getElementId() {
        if (this.element != null) {
            return this.element.getId();
        }
        return this.elementId;
    }

    void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @JsonIgnore
    public Element getElement() {
        return this.element;
    }

    void setElement(Element element) {
        this.element = element;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        if (StringUtils.isNullOrEmpty(content)) {
            this.content = null;
        } else {
            ImageUtils.validateImage(content);
            this.content = content.trim();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getName() {
        return this.getTitle();
    }
}

