/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Element;
import com.structurizr.model.Enterprise;
import com.structurizr.model.Model;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.StaticView;
import javax.annotation.Nonnull;

public final class SystemLandscapeView
extends StaticView {
    private Model model;
    private boolean enterpriseBoundaryVisible = true;

    SystemLandscapeView() {
    }

    SystemLandscapeView(Model model, String key, String description) {
        super(null, key, description);
        this.model = model;
    }

    @Override
    public String getName() {
        Enterprise enterprise = this.model.getEnterprise();
        return "System Landscape" + (enterprise != null && enterprise.getName().trim().length() > 0 ? " for " + enterprise.getName() : "");
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
    }

    @Override
    public void addNearestNeighbours(@Nonnull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        if (!(element instanceof Person) && !(element instanceof SoftwareSystem)) {
            throw new IllegalArgumentException("A person or software system must be specified.");
        }
        super.addNearestNeighbours(element, Person.class);
        super.addNearestNeighbours(element, SoftwareSystem.class);
    }

    public boolean isEnterpriseBoundaryVisible() {
        return this.enterpriseBoundaryVisible;
    }

    public void setEnterpriseBoundaryVisible(boolean enterpriseBoundaryVisible) {
        this.enterpriseBoundaryVisible = enterpriseBoundaryVisible;
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }
}

