/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.structurizr.Workspace;
import com.structurizr.documentation.DocumentationTemplate;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.FormatFinder;
import com.structurizr.documentation.Section;
import com.structurizr.documentation.TemplateMetadata;
import com.structurizr.model.SoftwareSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AutomaticDocumentationTemplate
extends DocumentationTemplate {
    public AutomaticDocumentationTemplate(Workspace workspace) {
        super(workspace);
    }

    public List<Section> addSections(File directory) throws IOException {
        return this.add(null, directory);
    }

    public List<Section> addSections(SoftwareSystem softwareSystem, File directory) throws IOException {
        if (softwareSystem == null) {
            throw new IllegalArgumentException("A software system must be specified.");
        }
        return this.add(softwareSystem, directory);
    }

    private List<Section> add(SoftwareSystem softwareSystem, File directory) throws IOException {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory.getCanonicalPath() + " does not exist.");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getCanonicalPath() + " is not a directory.");
        }
        Object[] filesInDirectory = directory.listFiles();
        if (filesInDirectory != null) {
            Arrays.sort(filesInDirectory);
            for (Object file : filesInDirectory) {
                Format format = FormatFinder.findFormat((File)file);
                String sectionDefinition = "";
                if (format == Format.Markdown) {
                    sectionDefinition = "##";
                } else if (format == Format.AsciiDoc) {
                    sectionDefinition = "==";
                }
                String content = new String(Files.readAllBytes(((File)file).toPath()), "UTF-8");
                String sectionName = ((File)file).getName();
                Matcher matcher = Pattern.compile("^" + sectionDefinition + " (.*?)$", 8).matcher(content);
                if (matcher.find()) {
                    sectionName = matcher.group(1);
                }
                Section section = this.addSection(softwareSystem, sectionName, format, content);
                sections.add(section);
            }
        }
        return sections;
    }

    @Override
    protected TemplateMetadata getMetadata() {
        return null;
    }
}

