/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Element;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.ModelItem;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Relationship
extends ModelItem {
    private Element source;
    private String sourceId;
    private Element destination;
    private String destinationId;
    private String description;
    private String technology;
    private InteractionStyle interactionStyle = InteractionStyle.Synchronous;
    private String linkedRelationshipId;

    Relationship() {
    }

    Relationship(Element source, Element destination, String description, String technology, InteractionStyle interactionStyle) {
        this();
        this.setSource(source);
        this.setDestination(destination);
        this.setDescription(description);
        this.setTechnology(technology);
        this.setInteractionStyle(interactionStyle);
        if (interactionStyle == InteractionStyle.Synchronous) {
            this.addTags(new String[]{"Synchronous"});
        } else {
            this.addTags(new String[]{"Asynchronous"});
        }
    }

    @JsonIgnore
    public Element getSource() {
        return this.source;
    }

    public String getSourceId() {
        if (this.source != null) {
            return this.source.getId();
        }
        return this.sourceId;
    }

    void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    void setSource(Element source) {
        this.source = source;
    }

    @JsonIgnore
    public Element getDestination() {
        return this.destination;
    }

    public String getDestinationId() {
        if (this.destination != null) {
            return this.destination.getId();
        }
        return this.destinationId;
    }

    void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    void setDestination(Element destination) {
        this.destination = destination;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    void setDescription(String description) {
        this.description = description;
    }

    public String getTechnology() {
        return this.technology;
    }

    void setTechnology(String technology) {
        this.technology = technology;
    }

    public InteractionStyle getInteractionStyle() {
        return this.interactionStyle;
    }

    void setInteractionStyle(InteractionStyle interactionStyle) {
        this.interactionStyle = interactionStyle;
    }

    public String getLinkedRelationshipId() {
        return this.linkedRelationshipId;
    }

    void setLinkedRelationshipId(String baseRelationshipId) {
        this.linkedRelationshipId = baseRelationshipId;
    }

    @Override
    protected Set<String> getRequiredTags() {
        if (this.linkedRelationshipId == null) {
            return new LinkedHashSet<String>(Collections.singletonList("Relationship"));
        }
        return Collections.emptySet();
    }

    public String toString() {
        return this.source.toString() + " ---[" + this.description + "]---> " + this.destination.toString();
    }
}

