/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.LayoutMergeStrategy;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultLayoutMergeStrategy
implements LayoutMergeStrategy {
    private static final Log log = LogFactory.getLog(View.class);

    @Override
    public void copyLayoutInformation(@Nonnull View sourceView, @Nonnull View destinationView) {
        this.setPaperSizeIfNotSpecified(sourceView, destinationView);
        for (ElementView destinationElementView : destinationView.getElements()) {
            ElementView sourceElementView = this.findElementView(sourceView, destinationElementView.getElement());
            if (sourceElementView != null) {
                destinationElementView.copyLayoutInformationFrom(sourceElementView);
                continue;
            }
            log.warn((Object)("There is no layout information for the element named " + destinationElementView.getElement().getName() + " on view " + sourceView.getKey()));
        }
        for (RelationshipView destinationRelationshipView : destinationView.getRelationships()) {
            RelationshipView sourceRelationshipView = destinationView instanceof DynamicView ? this.findRelationshipView(sourceView, destinationRelationshipView) : this.findRelationshipView(sourceView, destinationRelationshipView.getRelationship());
            if (sourceRelationshipView == null) continue;
            destinationRelationshipView.copyLayoutInformationFrom(sourceRelationshipView);
        }
    }

    private void setPaperSizeIfNotSpecified(@Nonnull View remoteView, @Nonnull View localView) {
        if (localView.getPaperSize() == null) {
            localView.setPaperSize(remoteView.getPaperSize());
        }
    }

    protected ElementView findElementView(View view, Element element) {
        return view.getElements().stream().filter(ev -> ev.getElement().getCanonicalName().equals(element.getCanonicalName())).findFirst().orElse(null);
    }

    protected RelationshipView findRelationshipView(View view, Relationship relationship) {
        for (RelationshipView rv : view.getRelationships()) {
            if (!rv.getRelationship().getSource().getCanonicalName().equals(relationship.getSource().getCanonicalName()) || !rv.getRelationship().getDestination().getCanonicalName().equals(relationship.getDestination().getCanonicalName()) || !rv.getRelationship().getDescription().equals(relationship.getDescription())) continue;
            return rv;
        }
        return null;
    }

    protected RelationshipView findRelationshipView(View view, RelationshipView relationshipView) {
        for (RelationshipView rv : view.getRelationships()) {
            if (!rv.getRelationship().getSource().getCanonicalName().equals(relationshipView.getRelationship().getSource().getCanonicalName()) || !rv.getRelationship().getDestination().getCanonicalName().equals(relationshipView.getRelationship().getDestination().getCanonicalName()) || !rv.getDescription().equals(relationshipView.getDescription()) || !rv.getOrder().equals(relationshipView.getOrder())) continue;
            return rv;
        }
        return null;
    }
}

