/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.Animation;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class StaticView
extends View {
    private List<Animation> animations = new ArrayList<Animation>();

    StaticView() {
    }

    StaticView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
    }

    public void addAllSoftwareSystems() {
        this.getModel().getSoftwareSystems().forEach(this::add);
    }

    public void add(@Nonnull SoftwareSystem softwareSystem) {
        this.add(softwareSystem, true);
    }

    public void add(@Nonnull SoftwareSystem softwareSystem, boolean addRelationships) {
        this.addElement(softwareSystem, addRelationships);
    }

    public void remove(@Nonnull SoftwareSystem softwareSystem) {
        this.removeElement(softwareSystem);
    }

    public void addAllPeople() {
        this.getModel().getPeople().forEach(this::add);
    }

    public void add(@Nonnull Person person) {
        this.add(person, true);
    }

    public void add(@Nonnull Person person, boolean addRelationships) {
        this.addElement(person, addRelationships);
    }

    public void remove(@Nonnull Person person) {
        this.removeElement(person);
    }

    public RelationshipView add(@Nonnull Relationship relationship) {
        return this.addRelationship(relationship);
    }

    public abstract void addAllElements();

    public abstract void addNearestNeighbours(@Nonnull Element var1);

    protected <T extends Element> void addNearestNeighbours(Element element, Class<T> typeOfElement) {
        if (element == null) {
            return;
        }
        this.addElement(element, true);
        Set<Relationship> relationships = this.getModel().getRelationships();
        relationships.stream().filter(r -> r.getSource().equals(element) && typeOfElement.isInstance(r.getDestination())).map(Relationship::getDestination).forEach(d -> this.addElement((Element)d, true));
        relationships.stream().filter(r -> r.getDestination().equals(element) && typeOfElement.isInstance(r.getSource())).map(Relationship::getSource).forEach(s -> this.addElement((Element)s, true));
    }

    public void removeElementsThatAreUnreachableFrom(Element element) {
        if (element != null) {
            HashSet<Element> elementsToShow = new HashSet<Element>();
            HashSet<Element> elementsVisited = new HashSet<Element>();
            this.findElementsToShow(element, element, elementsToShow, elementsVisited);
            for (ElementView elementView : this.getElements()) {
                if (elementsToShow.contains(elementView.getElement()) || !this.canBeRemoved(elementView.getElement())) continue;
                this.removeElement(elementView.getElement());
            }
        }
    }

    private void findElementsToShow(Element startingElement, Element element, Set<Element> elementsToShow, Set<Element> elementsVisited) {
        if (!elementsVisited.contains(element) && this.getElements().contains(new ElementView(element))) {
            elementsVisited.add(element);
            elementsToShow.add(element);
            if (!element.hasEfferentRelationshipWith(startingElement)) {
                element.getRelationships().forEach(r -> this.findElementsToShow(startingElement, r.getDestination(), elementsToShow, elementsVisited));
            }
        }
    }

    public final void removeElementsWithTag(@Nonnull String tag) {
        this.getElements().stream().map(ElementView::getElement).filter(e -> e.hasTag(tag)).forEach(this::removeElement);
    }

    public final void removeRelationshipsWithTag(@Nonnull String tag) {
        this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> r.hasTag(tag)).forEach(this::remove);
    }

    public void addAnimation(Element ... elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("One or more elements must be specified.");
        }
        HashSet<String> elementIdsInPreviousAnimationSteps = new HashSet<String>();
        HashSet<Element> elementsInThisAnimationStep = new HashSet<Element>();
        HashSet<Relationship> relationshipsInThisAnimationStep = new HashSet<Relationship>();
        for (Element element : elements) {
            if (!this.isElementInView(element)) continue;
            elementIdsInPreviousAnimationSteps.add(element.getId());
            elementsInThisAnimationStep.add(element);
        }
        if (elementsInThisAnimationStep.size() == 0) {
            throw new IllegalArgumentException("None of the specified elements exist in this view.");
        }
        for (Animation animationStep : this.animations) {
            elementIdsInPreviousAnimationSteps.addAll(animationStep.getElements());
        }
        for (RelationshipView relationshipView : this.getRelationships()) {
            if ((!elementsInThisAnimationStep.contains(relationshipView.getRelationship().getSource()) || !elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getDestination().getId())) && (!elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getSource().getId()) || !elementsInThisAnimationStep.contains(relationshipView.getRelationship().getDestination()))) continue;
            relationshipsInThisAnimationStep.add(relationshipView.getRelationship());
        }
        this.animations.add(new Animation(this.animations.size() + 1, elementsInThisAnimationStep, relationshipsInThisAnimationStep));
    }

    public List<Animation> getAnimations() {
        return new ArrayList<Animation>(this.animations);
    }

    void setAnimations(List<Animation> animations) {
        this.animations = animations != null ? new ArrayList<Animation>(animations) : new ArrayList<Animation>();
    }
}

