/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.util.StringUtils;
import com.structurizr.view.AutomaticLayout;
import com.structurizr.view.DefaultLayoutMergeStrategy;
import com.structurizr.view.ElementView;
import com.structurizr.view.LayoutMergeStrategy;
import com.structurizr.view.PaperSize;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.ViewSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class View {
    private SoftwareSystem softwareSystem;
    private String softwareSystemId;
    private String description = "";
    private String key;
    private PaperSize paperSize = null;
    private AutomaticLayout automaticLayout = null;
    private String title;
    private Set<ElementView> elementViews = new LinkedHashSet<ElementView>();
    private Set<RelationshipView> relationshipViews = new LinkedHashSet<RelationshipView>();
    private LayoutMergeStrategy layoutMergeStrategy = new DefaultLayoutMergeStrategy();
    private ViewSet viewSet;

    View() {
    }

    View(SoftwareSystem softwareSystem, String key, String description) {
        this.softwareSystem = softwareSystem;
        if (StringUtils.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        this.setKey(key);
        this.setDescription(description);
    }

    @JsonIgnore
    public Model getModel() {
        return this.softwareSystem.getModel();
    }

    @JsonIgnore
    public SoftwareSystem getSoftwareSystem() {
        return this.softwareSystem;
    }

    void setSoftwareSystem(SoftwareSystem softwareSystem) {
        this.softwareSystem = softwareSystem;
    }

    public String getSoftwareSystemId() {
        if (this.softwareSystem != null) {
            return this.softwareSystem.getId();
        }
        return this.softwareSystemId;
    }

    void setSoftwareSystemId(String softwareSystemId) {
        this.softwareSystemId = softwareSystemId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public String getKey() {
        return this.key;
    }

    void setKey(String key) {
        this.key = key;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public AutomaticLayout getAutomaticLayout() {
        return this.automaticLayout;
    }

    @JsonSetter
    void setAutomaticLayout(AutomaticLayout automaticLayout) {
        this.automaticLayout = automaticLayout;
    }

    public void setAutomaticLayout(boolean enable) {
        if (enable) {
            this.setAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 600, 200, false);
        } else {
            this.automaticLayout = null;
        }
    }

    public void setAutomaticLayout(AutomaticLayout.RankDirection rankDirection, int rankSeparation, int nodeSeparation, int edgeSeparation, boolean vertices) {
        this.automaticLayout = new AutomaticLayout(rankDirection, rankSeparation, nodeSeparation, edgeSeparation, vertices);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonIgnore
    public abstract String getName();

    protected final void addElement(Element element, boolean addRelationships) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        if (this.getModel().contains(element)) {
            this.elementViews.add(new ElementView(element));
            if (addRelationships) {
                this.addRelationships(element);
            }
        } else {
            throw new IllegalArgumentException("The element named " + element.getName() + " does not exist in the model associated with this view.");
        }
    }

    private void addRelationships(Element element) {
        Set elements = this.getElements().stream().map(ElementView::getElement).collect(Collectors.toSet());
        for (Relationship relationship : element.getRelationships()) {
            if (!elements.contains(relationship.getDestination())) continue;
            this.relationshipViews.add(new RelationshipView(relationship));
        }
        for (Element e : elements) {
            for (Relationship r : e.getRelationships()) {
                if (!r.getDestination().equals(element)) continue;
                this.relationshipViews.add(new RelationshipView(r));
            }
        }
    }

    protected void removeElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        if (!this.canBeRemoved(element)) {
            throw new IllegalArgumentException("The element named '" + element.getName() + "' cannot be removed from this view.");
        }
        ElementView elementView = new ElementView(element);
        this.elementViews.remove(elementView);
        for (RelationshipView relationshipView : this.getRelationships()) {
            if (!relationshipView.getRelationship().getSource().equals(element) && !relationshipView.getRelationship().getDestination().equals(element)) continue;
            this.remove(relationshipView.getRelationship());
        }
    }

    protected RelationshipView addRelationship(Relationship relationship) {
        if (relationship == null) {
            throw new IllegalArgumentException("A relationship must be specified.");
        }
        if (this.isElementInView(relationship.getSource()) && this.isElementInView(relationship.getDestination())) {
            RelationshipView relationshipView = new RelationshipView(relationship);
            this.relationshipViews.add(relationshipView);
            return relationshipView;
        }
        return null;
    }

    protected boolean isElementInView(Element element) {
        return this.elementViews.stream().filter(ev -> ev.getElement().equals(element)).count() > 0L;
    }

    protected RelationshipView addRelationship(Relationship relationship, String description, String order) {
        RelationshipView relationshipView = this.addRelationship(relationship);
        if (relationshipView != null) {
            relationshipView.setDescription(description);
            relationshipView.setOrder(order);
        }
        return relationshipView;
    }

    public void remove(Relationship relationship) {
        if (relationship != null) {
            RelationshipView relationshipView = new RelationshipView(relationship);
            this.relationshipViews.remove(relationshipView);
        }
    }

    public void removeRelationshipsNotConnectedToElement(Element element) {
        if (element != null) {
            this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> !r.getSource().equals(element) && !r.getDestination().equals(element)).forEach(this::remove);
        }
    }

    public Set<ElementView> getElements() {
        return new HashSet<ElementView>(this.elementViews);
    }

    void setElements(Set<ElementView> elementViews) {
        if (elementViews != null) {
            this.elementViews = new HashSet<ElementView>(elementViews);
        }
    }

    public Set<RelationshipView> getRelationships() {
        return new HashSet<RelationshipView>(this.relationshipViews);
    }

    void setRelationships(Set<RelationshipView> relationshipViews) {
        if (relationshipViews != null) {
            this.relationshipViews = new HashSet<RelationshipView>(relationshipViews);
        }
    }

    public void removeElementsWithNoRelationships() {
        Set<RelationshipView> relationships = this.getRelationships();
        HashSet elementIds = new HashSet();
        relationships.forEach(rv -> elementIds.add(rv.getRelationship().getSourceId()));
        relationships.forEach(rv -> elementIds.add(rv.getRelationship().getDestinationId()));
        for (ElementView elementView : this.getElements()) {
            if (elementIds.contains(elementView.getId())) continue;
            this.removeElement(elementView.getElement());
        }
    }

    public void setLayoutMergeStrategy(LayoutMergeStrategy layoutMergeStrategy) {
        if (layoutMergeStrategy == null) {
            throw new IllegalArgumentException("A LayoutMergeStrategy object must be provided.");
        }
        this.layoutMergeStrategy = layoutMergeStrategy;
    }

    void copyLayoutInformationFrom(@Nonnull View source) {
        this.layoutMergeStrategy.copyLayoutInformation(source, this);
    }

    public ElementView getElementView(@Nonnull Element element) {
        Optional<ElementView> elementView = this.elementViews.stream().filter(ev -> ev.getId().equals(element.getId())).findFirst();
        return elementView.orElse(null);
    }

    public RelationshipView getRelationshipView(@Nonnull Relationship relationship) {
        Optional<RelationshipView> relationshipView = this.relationshipViews.stream().filter(rv -> rv.getId().equals(relationship.getId())).findFirst();
        return relationshipView.orElse(null);
    }

    void setViewSet(@Nonnull ViewSet viewSet) {
        this.viewSet = viewSet;
    }

    @JsonIgnore
    public ViewSet getViewSet() {
        return this.viewSet;
    }

    protected abstract boolean canBeRemoved(Element var1);
}

