/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.view.FilterMode;
import com.structurizr.view.StaticView;
import com.structurizr.view.View;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class FilteredView {
    private View view;
    private String baseViewKey;
    private String key;
    private String description = "";
    private FilterMode mode = FilterMode.Exclude;
    private Set<String> tags = new HashSet<String>();

    FilteredView() {
    }

    FilteredView(StaticView view, String key, String description, FilterMode mode, String ... tags) {
        this.view = view;
        this.key = key;
        this.description = description;
        this.mode = mode;
        this.tags.addAll(Arrays.asList(tags));
    }

    @JsonIgnore
    public View getView() {
        return this.view;
    }

    void setView(View view) {
        this.view = view;
    }

    public String getBaseViewKey() {
        if (this.view != null) {
            return this.view.getKey();
        }
        return this.baseViewKey;
    }

    void setBaseViewKey(String baseViewKey) {
        this.baseViewKey = baseViewKey;
    }

    public String getKey() {
        return this.key;
    }

    void setKey(String key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public FilterMode getMode() {
        return this.mode;
    }

    void setMode(FilterMode mode) {
        this.mode = mode;
    }

    public Set<String> getTags() {
        return new HashSet<String>(this.tags);
    }
}

