/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.AbstractWorkspace;
import com.structurizr.WorkspaceValidationException;
import com.structurizr.documentation.Documentation;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.view.ViewSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Workspace
extends AbstractWorkspace {
    private static final Log log = LogFactory.getLog(Workspace.class);
    private Model model;
    private ViewSet viewSet;
    private Documentation documentation;

    Workspace() {
    }

    public Workspace(String name, String description) {
        super(name, description);
        this.model = this.createModel();
        this.viewSet = this.createViewSet();
        this.documentation = this.createDocumentation();
    }

    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    public ViewSet getViews() {
        return this.viewSet;
    }

    void setViews(ViewSet viewSet) {
        this.viewSet = viewSet;
    }

    private Model createModel() {
        try {
            Constructor constructor = Model.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Model)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ViewSet createViewSet() {
        try {
            Constructor constructor = ViewSet.class.getDeclaredConstructor(Model.class);
            constructor.setAccessible(true);
            return (ViewSet)constructor.newInstance(this.model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Documentation createDocumentation() {
        try {
            Constructor constructor = Documentation.class.getDeclaredConstructor(Model.class);
            constructor.setAccessible(true);
            return (Documentation)constructor.newInstance(this.model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void hydrate() {
        if (this.viewSet == null) {
            this.viewSet = this.createViewSet();
        }
        if (this.documentation == null) {
            this.documentation = this.createDocumentation();
        }
        this.hydrateModel();
        this.hydrateViewSet();
        this.hydrateDocumentation();
    }

    private void hydrateModel() {
        try {
            Method hydrateMethod = Model.class.getDeclaredMethod("hydrate", new Class[0]);
            hydrateMethod.setAccessible(true);
            hydrateMethod.invoke((Object)this.model, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null && ite.getCause() instanceof WorkspaceValidationException) {
                throw (WorkspaceValidationException)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void hydrateViewSet() {
        try {
            Method hydrateMethod = ViewSet.class.getDeclaredMethod("hydrate", Model.class);
            hydrateMethod.setAccessible(true);
            hydrateMethod.invoke((Object)this.viewSet, this.model);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null && ite.getCause() instanceof WorkspaceValidationException) {
                throw (WorkspaceValidationException)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void hydrateDocumentation() {
        try {
            Method hydrateMethod = Documentation.class.getDeclaredMethod("hydrate", Model.class);
            hydrateMethod.setAccessible(true);
            hydrateMethod.invoke((Object)this.documentation, this.model);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null && ite.getCause() instanceof WorkspaceValidationException) {
                throw (WorkspaceValidationException)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }

    void setDocumentation(@Nonnull Documentation documentation) {
        this.documentation = documentation;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.model.isEmpty() && this.viewSet.isEmpty() && this.documentation.isEmpty();
    }

    public int countAndLogWarnings() {
        LinkedList<String> warnings = new LinkedList<String>();
        this.getModel().getElements().stream().filter(e -> !(e instanceof SoftwareSystemInstance) && !(e instanceof ContainerInstance) && !(e instanceof DeploymentNode) && !(e instanceof InfrastructureNode)).filter(e -> e.getDescription() == null || e.getDescription().trim().length() == 0).forEach(e -> warnings.add(e.getCanonicalName() + " is missing a description."));
        this.getModel().getElements().stream().filter(e -> e instanceof Container).map(e -> (Container)e).filter(c -> c.getTechnology() == null || c.getTechnology().trim().length() == 0).forEach(c -> warnings.add(c.getCanonicalName() + " is missing a technology."));
        this.getModel().getElements().stream().filter(e -> e instanceof Component).map(e -> (Component)e).filter(c -> c.getTechnology() == null || c.getTechnology().trim().length() == 0).forEach(c -> warnings.add(c.getCanonicalName() + " is missing a technology."));
        for (Relationship relationship : this.getModel().getRelationships()) {
            if (relationship.getSource() instanceof Component && relationship.getDestination() instanceof Component && relationship.getSource().getParent().equals(relationship.getDestination().getParent()) || relationship.getDescription() != null && relationship.getDescription().trim().length() != 0) continue;
            warnings.add("The relationship between " + relationship.getSource().getCanonicalName() + " and " + relationship.getDestination().getCanonicalName() + " is missing a description.");
        }
        this.getViews().getSystemLandscapeViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("System Landscape view \"" + v.getName() + "\": Missing key"));
        this.getViews().getSystemContextViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("System Context view \"" + v.getName() + "\": Missing key"));
        this.getViews().getContainerViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Container view \"" + v.getName() + "\": Missing key"));
        this.getViews().getComponentViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Component view \"" + v.getName() + "\": Missing key"));
        this.getViews().getDynamicViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Dynamic view \"" + v.getName() + "\": Missing key"));
        this.getViews().getDeploymentViews().stream().filter(v -> v.getKey() == null).forEach(v -> warnings.add("Deployment view \"" + v.getName() + "\": Missing key"));
        warnings.forEach(arg_0 -> ((Log)log).warn(arg_0));
        return warnings.size();
    }

    private String typeof(Element element) {
        if (element instanceof SoftwareSystem) {
            return "software system";
        }
        return element.getClass().getSimpleName().toLowerCase();
    }
}

