/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CanonicalNameGenerator;
import com.structurizr.model.CodeElement;
import com.structurizr.model.CodeElementRole;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.StaticStructureElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public final class Component
extends StaticStructureElement {
    private Container parent;
    private String technology;
    private Set<CodeElement> codeElements = new HashSet<CodeElement>();
    private long size;

    Component() {
    }

    @Override
    @JsonIgnore
    public Element getParent() {
        return this.parent;
    }

    @JsonIgnore
    public Container getContainer() {
        return this.parent;
    }

    void setParent(Container parent) {
        this.parent = parent;
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }

    @JsonIgnore
    public CodeElement getType() {
        return this.codeElements.stream().filter(ce -> ce.getRole() == CodeElementRole.Primary).findFirst().orElse(null);
    }

    public CodeElement setType(String type) {
        Optional<CodeElement> optional = this.codeElements.stream().filter(ce -> ce.getRole() == CodeElementRole.Primary).findFirst();
        optional.ifPresent(codeElement -> this.codeElements.remove(codeElement));
        CodeElement codeElement2 = new CodeElement(type);
        codeElement2.setRole(CodeElementRole.Primary);
        this.codeElements.add(codeElement2);
        return codeElement2;
    }

    public Set<CodeElement> getCode() {
        return new HashSet<CodeElement>(this.codeElements);
    }

    void setCode(Set<CodeElement> codeElements) {
        this.codeElements = codeElements;
    }

    public CodeElement addSupportingType(String type) {
        CodeElement codeElement = new CodeElement(type);
        codeElement.setRole(CodeElementRole.Supporting);
        this.codeElements.add(codeElement);
        return codeElement;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public String getCanonicalName() {
        return new CanonicalNameGenerator().generate(this);
    }

    @Override
    protected Set<String> getRequiredTags() {
        return new LinkedHashSet<String>(Arrays.asList("Element", "Component"));
    }
}

