/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.structurizr.util.Url;
import com.structurizr.view.Branding;
import com.structurizr.view.MetadataSymbols;
import com.structurizr.view.Styles;
import com.structurizr.view.Terminology;
import com.structurizr.view.View;
import com.structurizr.view.ViewSortOrder;
import java.util.ArrayList;
import java.util.List;

public final class Configuration {
    private Branding branding = new Branding();
    private Styles styles = new Styles();
    private List<String> themes = new ArrayList<String>();
    private Terminology terminology = new Terminology();
    private MetadataSymbols metadataSymbols;
    private String defaultView;
    private String lastSavedView;
    private ViewSortOrder viewSortOrder;

    public Styles getStyles() {
        return this.styles;
    }

    @JsonIgnore
    @Deprecated
    public String getTheme() {
        if (this.themes == null || this.themes.size() == 0) {
            return null;
        }
        return this.themes.get(0);
    }

    @JsonSetter
    void setTheme(String url) {
        this.setThemes(url);
    }

    public String[] getThemes() {
        return this.themes.toArray(new String[0]);
    }

    public void setThemes(String ... themes) {
        if (themes != null) {
            for (String url : themes) {
                this.addTheme(url);
            }
        }
    }

    public void addTheme(String url) {
        if (url != null && url.trim().length() > 0) {
            if (Url.isUrl(url)) {
                if (!this.themes.contains(url)) {
                    this.themes.add(url.trim());
                }
            } else {
                throw new IllegalArgumentException(url + " is not a valid URL.");
            }
        }
    }

    public String getDefaultView() {
        return this.defaultView;
    }

    @JsonSetter
    void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public void setDefaultView(View view) {
        if (view != null) {
            this.defaultView = view.getKey();
        }
    }

    @JsonGetter
    String getLastSavedView() {
        return this.lastSavedView;
    }

    @JsonSetter
    void setLastSavedView(String lastSavedView) {
        this.lastSavedView = lastSavedView;
    }

    public void copyConfigurationFrom(Configuration configuration) {
        this.setLastSavedView(configuration.getLastSavedView());
    }

    public Branding getBranding() {
        return this.branding;
    }

    void setBranding(Branding branding) {
        this.branding = branding;
    }

    public Terminology getTerminology() {
        return this.terminology;
    }

    void setTerminology(Terminology terminology) {
        this.terminology = terminology;
    }

    public MetadataSymbols getMetadataSymbols() {
        return this.metadataSymbols;
    }

    public void setMetadataSymbols(MetadataSymbols metadataSymbols) {
        this.metadataSymbols = metadataSymbols;
    }

    public ViewSortOrder getViewSortOrder() {
        return this.viewSortOrder;
    }

    public void setViewSortOrder(ViewSortOrder viewSortOrder) {
        this.viewSortOrder = viewSortOrder;
    }
}

