/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.Animation;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class DeploymentView
extends View {
    private Model model;
    private String environment = "Default";
    private List<Animation> animations = new ArrayList<Animation>();

    DeploymentView() {
    }

    DeploymentView(Model model, String key, String description) {
        super(null, key, description);
        this.model = model;
    }

    DeploymentView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.model = softwareSystem.getModel();
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    public void addDefaultElements() {
        this.addAllDeploymentNodes();
    }

    public void addAllDeploymentNodes() {
        for (DeploymentNode deploymentNode : this.getModel().getDeploymentNodes()) {
            if (deploymentNode.getParent() != null || this.getEnvironment() != null && !this.getEnvironment().equals(deploymentNode.getEnvironment())) continue;
            this.add(deploymentNode);
        }
    }

    public void add(@Nonnull DeploymentNode deploymentNode) {
        this.add(deploymentNode, true);
    }

    public void add(@Nonnull DeploymentNode deploymentNode, boolean addRelationships) {
        if (deploymentNode == null) {
            throw new IllegalArgumentException("A deployment node must be specified.");
        }
        if (this.addElementInstancesAndDeploymentNodesAndInfrastructureNodes(deploymentNode, addRelationships)) {
            for (Element parent = deploymentNode.getParent(); parent != null; parent = parent.getParent()) {
                this.addElement(parent, addRelationships);
            }
        }
    }

    public void add(@Nonnull InfrastructureNode infrastructureNode) {
        this.addElement(infrastructureNode, true);
        for (DeploymentNode parent = (DeploymentNode)infrastructureNode.getParent(); parent != null; parent = (DeploymentNode)parent.getParent()) {
            this.addElement(parent, true);
        }
    }

    public void add(@Nonnull SoftwareSystemInstance softwareSystemInstance) {
        this.addElement(softwareSystemInstance, true);
        for (DeploymentNode parent = (DeploymentNode)softwareSystemInstance.getParent(); parent != null; parent = (DeploymentNode)parent.getParent()) {
            this.addElement(parent, true);
        }
    }

    public void add(@Nonnull ContainerInstance containerInstance) {
        this.addElement(containerInstance, true);
        for (DeploymentNode parent = (DeploymentNode)containerInstance.getParent(); parent != null; parent = (DeploymentNode)parent.getParent()) {
            this.addElement(parent, true);
        }
    }

    public void remove(@Nonnull DeploymentNode deploymentNode) {
        for (SoftwareSystemInstance softwareSystemInstance : deploymentNode.getSoftwareSystemInstances()) {
            this.remove(softwareSystemInstance);
        }
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            this.remove(containerInstance);
        }
        for (InfrastructureNode infrastructureNode : deploymentNode.getInfrastructureNodes()) {
            this.remove(infrastructureNode);
        }
        for (DeploymentNode child : deploymentNode.getChildren()) {
            this.remove(child);
        }
        this.removeElement(deploymentNode);
    }

    public void remove(@Nonnull InfrastructureNode infrastructureNode) {
        this.removeElement(infrastructureNode);
    }

    public void remove(@Nonnull SoftwareSystemInstance softwareSystemInstance) {
        this.removeElement(softwareSystemInstance);
    }

    public void remove(@Nonnull ContainerInstance containerInstance) {
        this.removeElement(containerInstance);
    }

    private boolean addElementInstancesAndDeploymentNodesAndInfrastructureNodes(DeploymentNode deploymentNode, boolean addRelationships) {
        boolean hasElementsOrInfrastructureNodes = false;
        for (SoftwareSystemInstance softwareSystemInstance : deploymentNode.getSoftwareSystemInstances()) {
            try {
                this.addElement(softwareSystemInstance, addRelationships);
                hasElementsOrInfrastructureNodes = true;
            }
            catch (ElementNotPermittedInViewException elementNotPermittedInViewException) {}
        }
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            Container container = containerInstance.getContainer();
            if (this.getSoftwareSystem() != null && !container.getParent().equals(this.getSoftwareSystem())) continue;
            try {
                this.addElement(containerInstance, addRelationships);
                hasElementsOrInfrastructureNodes = true;
            }
            catch (ElementNotPermittedInViewException elementNotPermittedInViewException) {}
        }
        for (InfrastructureNode infrastructureNode : deploymentNode.getInfrastructureNodes()) {
            this.addElement(infrastructureNode, addRelationships);
            hasElementsOrInfrastructureNodes = true;
        }
        for (DeploymentNode child : deploymentNode.getChildren()) {
            hasElementsOrInfrastructureNodes |= this.addElementInstancesAndDeploymentNodesAndInfrastructureNodes(child, addRelationships);
        }
        if (hasElementsOrInfrastructureNodes) {
            this.addElement(deploymentNode, addRelationships);
        }
        return hasElementsOrInfrastructureNodes;
    }

    public RelationshipView add(@Nonnull Relationship relationship) {
        return this.addRelationship(relationship);
    }

    @Override
    public String getName() {
        String name = this.getSoftwareSystem() != null ? this.getSoftwareSystem().getName() + " - Deployment" : "Deployment";
        if (!StringUtils.isNullOrEmpty(this.getEnvironment())) {
            name = name + " - " + this.getEnvironment();
        }
        return name;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @Override
    protected void checkElementCanBeAdded(Element elementToBeAdded) {
        Set softwareSystemIds;
        SoftwareSystemInstance ssi;
        if (elementToBeAdded instanceof CustomElement) {
            return;
        }
        if (!(elementToBeAdded instanceof DeploymentElement)) {
            throw new ElementNotPermittedInViewException("Only deployment nodes, infrastructure nodes, software system instances, and container instances can be added to deployment views.");
        }
        DeploymentElement deploymentElementToBeAdded = (DeploymentElement)elementToBeAdded;
        if (!deploymentElementToBeAdded.getEnvironment().equals(this.getEnvironment())) {
            throw new ElementNotPermittedInViewException("Only elements in the " + this.getEnvironment() + " deployment environment can be added to this view.");
        }
        if (this.getSoftwareSystem() != null && elementToBeAdded instanceof SoftwareSystemInstance && (ssi = (SoftwareSystemInstance)elementToBeAdded).getSoftwareSystem().equals(this.getSoftwareSystem())) {
            throw new ElementNotPermittedInViewException("The software system in scope cannot be added to a deployment view.");
        }
        if (elementToBeAdded instanceof SoftwareSystemInstance) {
            SoftwareSystemInstance softwareSystemInstanceToBeAdded = (SoftwareSystemInstance)elementToBeAdded;
            softwareSystemIds = this.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof ContainerInstance).map(e -> (ContainerInstance)e).map(ci -> ci.getContainer().getSoftwareSystem().getId()).collect(Collectors.toSet());
            if (softwareSystemIds.contains(softwareSystemInstanceToBeAdded.getSoftwareSystemId())) {
                throw new ElementNotPermittedInViewException("A child of " + elementToBeAdded.getName() + " is already in this view.");
            }
        }
        if (elementToBeAdded instanceof ContainerInstance) {
            ContainerInstance containerInstanceToBeAdded = (ContainerInstance)elementToBeAdded;
            softwareSystemIds = this.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof SoftwareSystemInstance).map(e -> (SoftwareSystemInstance)e).map(SoftwareSystemInstance::getSoftwareSystemId).collect(Collectors.toSet());
            if (softwareSystemIds.contains(containerInstanceToBeAdded.getContainer().getSoftwareSystem().getId())) {
                throw new ElementNotPermittedInViewException("A parent of " + elementToBeAdded.getName() + " is already in this view.");
            }
        }
    }

    @Override
    protected boolean canBeRemoved(Element element) {
        return true;
    }

    public void addAnimation(InfrastructureNode ... infrastructureNodes) {
        if (infrastructureNodes == null || infrastructureNodes.length == 0) {
            throw new IllegalArgumentException("One or more infrastructure nodes must be specified.");
        }
        this.addAnimation((StaticStructureElementInstance[])new ContainerInstance[0], infrastructureNodes);
    }

    public void addAnimation(StaticStructureElementInstance ... elementInstances) {
        if (elementInstances == null || elementInstances.length == 0) {
            throw new IllegalArgumentException("One or more software system/container instances must be specified.");
        }
        this.addAnimation(elementInstances, new InfrastructureNode[0]);
    }

    public void addAnimation(StaticStructureElementInstance[] elementInstances, InfrastructureNode[] infrastructureNodes) {
        if (!(elementInstances != null && elementInstances.length != 0 || infrastructureNodes != null && infrastructureNodes.length != 0)) {
            throw new IllegalArgumentException("One or more software system/container instances and/or infrastructure nodes must be specified.");
        }
        ArrayList elements = new ArrayList();
        if (elementInstances != null) {
            Collections.addAll(elements, elementInstances);
        }
        if (infrastructureNodes != null) {
            Collections.addAll(elements, infrastructureNodes);
        }
        this.addAnimationStep(elements.toArray(new Element[0]));
    }

    private void addAnimationStep(Element ... elements) {
        HashSet<String> elementIdsInPreviousAnimationSteps = new HashSet<String>();
        for (Animation animationStep : this.animations) {
            elementIdsInPreviousAnimationSteps.addAll(animationStep.getElements());
        }
        HashSet<Element> elementsInThisAnimationStep = new HashSet<Element>();
        HashSet<Relationship> relationshipsInThisAnimationStep = new HashSet<Relationship>();
        for (Element element : elements) {
            if (!this.isElementInView(element) || elementIdsInPreviousAnimationSteps.contains(element.getId())) continue;
            elementIdsInPreviousAnimationSteps.add(element.getId());
            elementsInThisAnimationStep.add(element);
            for (Element deploymentNode = this.findDeploymentNode(element); deploymentNode != null; deploymentNode = ((Element)deploymentNode).getParent()) {
                if (elementIdsInPreviousAnimationSteps.contains(deploymentNode.getId())) continue;
                elementIdsInPreviousAnimationSteps.add(deploymentNode.getId());
                elementsInThisAnimationStep.add(deploymentNode);
            }
        }
        if (elementsInThisAnimationStep.size() == 0) {
            throw new IllegalArgumentException("None of the specified container instances exist in this view.");
        }
        for (RelationshipView relationshipView : this.getRelationships()) {
            if ((!elementsInThisAnimationStep.contains(relationshipView.getRelationship().getSource()) || !elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getDestination().getId())) && (!elementIdsInPreviousAnimationSteps.contains(relationshipView.getRelationship().getSource().getId()) || !elementsInThisAnimationStep.contains(relationshipView.getRelationship().getDestination()))) continue;
            relationshipsInThisAnimationStep.add(relationshipView.getRelationship());
        }
        this.animations.add(new Animation(this.animations.size() + 1, elementsInThisAnimationStep, relationshipsInThisAnimationStep));
    }

    private DeploymentNode findDeploymentNode(Element e) {
        for (Element element : this.getModel().getElements()) {
            if (!(element instanceof DeploymentNode)) continue;
            DeploymentNode deploymentNode = (DeploymentNode)element;
            if (e instanceof ContainerInstance && deploymentNode.getContainerInstances().contains(e)) {
                return deploymentNode;
            }
            if (!(e instanceof InfrastructureNode) || !deploymentNode.getInfrastructureNodes().contains(e)) continue;
            return deploymentNode;
        }
        return null;
    }

    public List<Animation> getAnimations() {
        return new ArrayList<Animation>(this.animations);
    }

    void setAnimations(List<Animation> animations) {
        this.animations = animations != null ? new ArrayList<Animation>(animations) : new ArrayList<Animation>();
    }
}

