/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.configuration;

import com.structurizr.configuration.Role;
import com.structurizr.util.StringUtils;

public final class User
implements Comparable<User> {
    private String username;
    private Role role;

    User() {
    }

    public User(String username, Role role) {
        if (StringUtils.isNullOrEmpty(username)) {
            throw new IllegalArgumentException("A username must be specified.");
        }
        if (role == null) {
            throw new IllegalArgumentException("A role must be specified.");
        }
        this.setUsername(username);
        this.setRole(role);
    }

    public String getUsername() {
        return this.username;
    }

    void setUsername(String username) {
        this.username = username;
    }

    public Role getRole() {
        return this.role;
    }

    void setRole(Role role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.username.equals(user.username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public String toString() {
        return "User {username='" + this.username + "', role=" + this.role + "}";
    }

    @Override
    public int compareTo(User user) {
        return this.getUsername().compareTo(user.getUsername());
    }
}

