/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Documentation;
import com.structurizr.model.CanonicalNameGenerator;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Location;
import com.structurizr.model.StaticStructureElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SoftwareSystem
extends StaticStructureElement
implements Documentable {
    private Location location = Location.Unspecified;
    private Set<Container> containers = new TreeSet<Container>();
    private Documentation documentation = new Documentation();

    @Override
    @JsonIgnore
    public Element getParent() {
        return null;
    }

    SoftwareSystem() {
    }

    @Deprecated
    public Location getLocation() {
        return this.location;
    }

    @Deprecated
    void setLocation(Location location) {
        this.location = location != null ? location : Location.Unspecified;
    }

    void add(Container container) {
        this.containers.add(container);
    }

    @Nonnull
    public Set<Container> getContainers() {
        return new TreeSet<Container>(this.containers);
    }

    void setContainers(Set<Container> containers) {
        if (containers != null) {
            this.containers = new TreeSet<Container>(containers);
        }
    }

    @JsonIgnore
    public boolean hasContainers() {
        return !this.containers.isEmpty();
    }

    @Nonnull
    public Container addContainer(@Nonnull String name) {
        return this.addContainer(name, "");
    }

    @Nonnull
    public Container addContainer(@Nonnull String name, String description) {
        return this.addContainer(name, description, "");
    }

    @Nonnull
    public Container addContainer(@Nonnull String name, String description, String technology) {
        return this.getModel().addContainer(this, name, description, technology);
    }

    void remove(Container container) {
        this.containers.remove(container);
    }

    @Nullable
    public Container getContainerWithName(@Nonnull String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A container name must be provided.");
        }
        for (Container container : this.getContainers()) {
            if (!container.getName().equals(name)) continue;
            return container;
        }
        return null;
    }

    @Nullable
    public Container getContainerWithId(@Nonnull String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("A container ID must be provided.");
        }
        for (Container container : this.getContainers()) {
            if (!container.getId().equals(id)) continue;
            return container;
        }
        return null;
    }

    @Override
    public String getCanonicalName() {
        return new CanonicalNameGenerator().generate(this);
    }

    @Override
    public Set<String> getDefaultTags() {
        return new LinkedHashSet<String>(Arrays.asList("Element", "Software System"));
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    void setDocumentation(@Nonnull Documentation documentation) {
        this.documentation = documentation;
    }
}

