/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

public final class AutomaticLayout {
    private Implementation implementation;
    private RankDirection rankDirection;
    private int rankSeparation;
    private int nodeSeparation;
    private int edgeSeparation;
    private boolean vertices;
    private boolean applied;

    AutomaticLayout() {
    }

    AutomaticLayout(Implementation implementation, RankDirection rankDirection, int rankSeparation, int nodeSeparation, int edgeSeparation, boolean vertices) {
        this.setImplementation(implementation);
        this.setRankDirection(rankDirection);
        this.setRankSeparation(rankSeparation);
        this.setNodeSeparation(nodeSeparation);
        this.setEdgeSeparation(edgeSeparation);
        this.setVertices(vertices);
        this.setApplied(false);
    }

    public Implementation getImplementation() {
        return this.implementation;
    }

    void setImplementation(Implementation implementation) {
        this.implementation = implementation;
    }

    public RankDirection getRankDirection() {
        return this.rankDirection;
    }

    void setRankDirection(RankDirection rankDirection) {
        if (rankDirection == null) {
            throw new IllegalArgumentException("A rank direction must be specified.");
        }
        this.rankDirection = rankDirection;
    }

    public int getRankSeparation() {
        return this.rankSeparation;
    }

    void setRankSeparation(int rankSeparation) {
        if (rankSeparation < 0) {
            throw new IllegalArgumentException("The rank separation must be a positive integer.");
        }
        this.rankSeparation = rankSeparation;
    }

    public int getNodeSeparation() {
        return this.nodeSeparation;
    }

    void setNodeSeparation(int nodeSeparation) {
        if (nodeSeparation < 0) {
            throw new IllegalArgumentException("The node separation must be a positive integer.");
        }
        this.nodeSeparation = nodeSeparation;
    }

    public int getEdgeSeparation() {
        return this.edgeSeparation;
    }

    void setEdgeSeparation(int edgeSeparation) {
        if (edgeSeparation < 0) {
            throw new IllegalArgumentException("The edge separation must be a positive integer.");
        }
        this.edgeSeparation = edgeSeparation;
    }

    public boolean isVertices() {
        return this.vertices;
    }

    void setVertices(boolean vertices) {
        this.vertices = vertices;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public static enum Implementation {
        Graphviz,
        Dagre;

    }

    public static enum RankDirection {
        TopBottom,
        BottomTop,
        LeftRight,
        RightLeft;

    }
}

