/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.view.FilterMode;
import com.structurizr.view.StaticView;
import com.structurizr.view.View;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

public final class FilteredView
extends View {
    private StaticView view;
    private String baseViewKey;
    private FilterMode mode = FilterMode.Exclude;
    private final Set<String> tags = new TreeSet<String>();

    FilteredView() {
    }

    FilteredView(StaticView view, String key, String description, FilterMode mode, String ... tags) {
        this.view = view;
        this.setKey(key);
        this.setDescription(description);
        this.mode = mode;
        this.tags.addAll(Arrays.asList(tags));
    }

    @JsonIgnore
    public View getView() {
        return this.view;
    }

    void setView(StaticView view) {
        this.view = view;
    }

    public String getBaseViewKey() {
        if (this.view != null) {
            return this.view.getKey();
        }
        return this.baseViewKey;
    }

    void setBaseViewKey(String baseViewKey) {
        this.baseViewKey = baseViewKey;
    }

    public FilterMode getMode() {
        return this.mode;
    }

    void setMode(FilterMode mode) {
        this.mode = mode;
    }

    public Set<String> getTags() {
        return new TreeSet<String>(this.tags);
    }

    @Override
    public String getName() {
        return "Filtered: " + this.view.getName();
    }
}

