/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.util.StringUtils;
import com.structurizr.view.AutomaticLayout;
import com.structurizr.view.DefaultLayoutMergeStrategy;
import com.structurizr.view.Dimensions;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.ElementView;
import com.structurizr.view.LayoutMergeStrategy;
import com.structurizr.view.PaperSize;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import com.structurizr.view.ViewSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class ModelView
extends View {
    private static final int DEFAULT_RANK_SEPARATION = 300;
    private static final int DEFAULT_NODE_SEPARATION = 300;
    private SoftwareSystem softwareSystem;
    private String softwareSystemId;
    private PaperSize paperSize = null;
    private Dimensions dimensions = null;
    private AutomaticLayout automaticLayout = null;
    private boolean mergeFromRemote = true;
    private Set<ElementView> elementViews = new TreeSet<ElementView>();
    private Set<RelationshipView> relationshipViews = new TreeSet<RelationshipView>();
    private LayoutMergeStrategy layoutMergeStrategy = new DefaultLayoutMergeStrategy();
    private ViewSet viewSet;

    ModelView() {
    }

    ModelView(SoftwareSystem softwareSystem, String key, String description) {
        this.softwareSystem = softwareSystem;
        if (StringUtils.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("A key must be specified.");
        }
        this.setKey(key);
        this.setDescription(description);
    }

    @JsonIgnore
    public Model getModel() {
        return this.softwareSystem.getModel();
    }

    @JsonIgnore
    public SoftwareSystem getSoftwareSystem() {
        return this.softwareSystem;
    }

    void setSoftwareSystem(SoftwareSystem softwareSystem) {
        this.softwareSystem = softwareSystem;
    }

    public String getSoftwareSystemId() {
        if (this.softwareSystem != null) {
            return this.softwareSystem.getId();
        }
        return this.softwareSystemId;
    }

    void setSoftwareSystemId(String softwareSystemId) {
        this.softwareSystemId = softwareSystemId;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public AutomaticLayout getAutomaticLayout() {
        return this.automaticLayout;
    }

    @JsonSetter
    void setAutomaticLayout(AutomaticLayout automaticLayout) {
        this.automaticLayout = automaticLayout;
    }

    public void enableAutomaticLayout() {
        this.enableAutomaticLayout(AutomaticLayout.RankDirection.TopBottom, 300, 600, 200, false);
    }

    public void enableAutomaticLayout(AutomaticLayout.RankDirection rankDirection, int rankSeparation, int nodeSeparation, int edgeSeparation, boolean vertices) {
        this.automaticLayout = new AutomaticLayout(AutomaticLayout.Implementation.Dagre, rankDirection, rankSeparation, nodeSeparation, edgeSeparation, vertices);
    }

    public void enableAutomaticLayout(AutomaticLayout.RankDirection rankDirection) {
        this.enableAutomaticLayout(rankDirection, 300, 300);
    }

    public void enableAutomaticLayout(AutomaticLayout.RankDirection rankDirection, int rankSeparation, int nodeSeparation) {
        this.automaticLayout = new AutomaticLayout(AutomaticLayout.Implementation.Graphviz, rankDirection, rankSeparation, nodeSeparation, 0, false);
    }

    public void disableAutomaticLayout() {
        this.automaticLayout = null;
    }

    public boolean getMergeFromRemote() {
        return this.mergeFromRemote;
    }

    @JsonIgnore
    public void setMergeFromRemote(boolean mergeFromRemote) {
        this.mergeFromRemote = mergeFromRemote;
    }

    protected final void addElement(Element element, boolean addRelationships) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        if (this.getModel().contains(element)) {
            this.checkElementCanBeAdded(element);
            this.elementViews.add(new ElementView(element));
            if (addRelationships) {
                this.addRelationships(element);
            }
        } else {
            throw new IllegalArgumentException("The element named " + element.getName() + " does not exist in the model associated with this view.");
        }
    }

    protected abstract void checkElementCanBeAdded(Element var1);

    private void addRelationships(Element element) {
        Set elements = this.getElements().stream().map(ElementView::getElement).collect(Collectors.toSet());
        for (Relationship relationship : element.getRelationships()) {
            if (!elements.contains(relationship.getDestination())) continue;
            this.relationshipViews.add(new RelationshipView(relationship));
        }
        for (Element e : elements) {
            for (Relationship r : e.getRelationships()) {
                if (!r.getDestination().equals(element)) continue;
                this.relationshipViews.add(new RelationshipView(r));
            }
        }
    }

    protected void removeElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("An element must be specified.");
        }
        if (!this.canBeRemoved(element)) {
            throw new IllegalArgumentException("The element named '" + element.getName() + "' cannot be removed from this view.");
        }
        ElementView elementView = new ElementView(element);
        this.elementViews.remove(elementView);
        for (RelationshipView relationshipView : this.getRelationships()) {
            if (!relationshipView.getRelationship().getSource().equals(element) && !relationshipView.getRelationship().getDestination().equals(element)) continue;
            this.remove(relationshipView.getRelationship());
        }
    }

    protected RelationshipView addRelationship(Relationship relationship) {
        if (relationship == null) {
            throw new IllegalArgumentException("A relationship must be specified.");
        }
        if (this.isElementInView(relationship.getSource()) && this.isElementInView(relationship.getDestination())) {
            RelationshipView relationshipView = new RelationshipView(relationship);
            this.relationshipViews.add(relationshipView);
            return relationshipView;
        }
        return null;
    }

    public boolean isElementInView(Element element) {
        return this.elementViews.stream().anyMatch(ev -> ev.getElement().equals(element));
    }

    public void remove(Relationship relationship) {
        if (relationship != null) {
            RelationshipView relationshipView = new RelationshipView(relationship);
            this.relationshipViews.remove(relationshipView);
        }
    }

    public void removeRelationshipsNotConnectedToElement(Element element) {
        if (element != null) {
            this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> !r.getSource().equals(element) && !r.getDestination().equals(element)).forEach(this::remove);
        }
    }

    public void removeRelationshipsNotConnectedToElements(Set<? extends Element> elements) {
        if (elements != null) {
            this.getRelationships().stream().map(RelationshipView::getRelationship).filter(r -> !elements.contains(r.getSource()) && !elements.contains(r.getDestination())).forEach(this::remove);
        }
    }

    public Set<ElementView> getElements() {
        return new TreeSet<ElementView>(this.elementViews);
    }

    void setElements(Set<ElementView> elementViews) {
        if (elementViews != null) {
            this.elementViews = new TreeSet<ElementView>(elementViews);
        }
    }

    public Set<RelationshipView> getRelationships() {
        return new TreeSet<RelationshipView>(this.relationshipViews);
    }

    void setRelationships(Set<RelationshipView> relationshipViews) {
        if (relationshipViews != null) {
            this.relationshipViews = new TreeSet<RelationshipView>(relationshipViews);
        }
    }

    public void removeElementsWithNoRelationships() {
        Set<RelationshipView> relationships = this.getRelationships();
        HashSet elementIds = new HashSet();
        relationships.forEach(rv -> elementIds.add(rv.getRelationship().getSourceId()));
        relationships.forEach(rv -> elementIds.add(rv.getRelationship().getDestinationId()));
        for (ElementView elementView : this.getElements()) {
            if (elementIds.contains(elementView.getId())) continue;
            this.removeElement(elementView.getElement());
        }
    }

    public void setLayoutMergeStrategy(LayoutMergeStrategy layoutMergeStrategy) {
        if (layoutMergeStrategy == null) {
            throw new IllegalArgumentException("A LayoutMergeStrategy object must be provided.");
        }
        this.layoutMergeStrategy = layoutMergeStrategy;
    }

    public void copyLayoutInformationFrom(@Nonnull ModelView source) {
        this.layoutMergeStrategy.copyLayoutInformation(source, this);
    }

    public ElementView getElementView(@Nonnull Element element) {
        Optional<ElementView> elementView = this.elementViews.stream().filter(ev -> ev.getId().equals(element.getId())).findFirst();
        return elementView.orElse(null);
    }

    public RelationshipView getRelationshipView(@Nonnull Relationship relationship) {
        Optional<RelationshipView> relationshipView = this.relationshipViews.stream().filter(rv -> rv.getId().equals(relationship.getId())).findFirst();
        return relationshipView.orElse(null);
    }

    @Override
    void setViewSet(@Nonnull ViewSet viewSet) {
        this.viewSet = viewSet;
    }

    @Override
    @JsonIgnore
    public ViewSet getViewSet() {
        return this.viewSet;
    }

    protected abstract boolean canBeRemoved(Element var1);

    final void checkParentAndChildrenHaveNotAlreadyBeenAdded(StaticStructureElement elementToBeAdded) {
        Element parent;
        Set idsOfElementsInView = this.getElements().stream().map(ElementView::getElement).map(ModelItem::getId).collect(Collectors.toSet());
        for (parent = elementToBeAdded.getParent(); parent != null; parent = parent.getParent()) {
            if (!idsOfElementsInView.contains(parent.getId())) continue;
            throw new ElementNotPermittedInViewException("A parent of " + elementToBeAdded.getName() + " is already in this view.");
        }
        HashSet<String> elementParentIds = new HashSet<String>();
        for (ElementView elementView : this.getElements()) {
            Element element = elementView.getElement();
            for (parent = element.getParent(); parent != null; parent = parent.getParent()) {
                elementParentIds.add(parent.getId());
            }
        }
        if (elementParentIds.contains(elementToBeAdded.getId())) {
            throw new ElementNotPermittedInViewException("A child of " + elementToBeAdded.getName() + " is already in this view.");
        }
    }

    protected <T extends Element> void addNearestNeighbours(Element element, Class<T> typeOfElement) {
        if (element == null) {
            return;
        }
        try {
            this.addElement(element, true);
            Set<Relationship> relationships = this.getModel().getRelationships();
            relationships.stream().filter(r -> r.getSource().equals(element) && typeOfElement.isInstance(r.getDestination())).map(Relationship::getDestination).forEach(d -> {
                try {
                    this.addElement((Element)d, true);
                }
                catch (ElementNotPermittedInViewException e) {
                    System.out.println(e.getMessage() + " (ignoring " + d.getName() + ")");
                }
            });
            relationships.stream().filter(r -> r.getDestination().equals(element) && typeOfElement.isInstance(r.getSource())).map(Relationship::getSource).forEach(s -> {
                try {
                    this.addElement((Element)s, true);
                }
                catch (ElementNotPermittedInViewException e) {
                    System.out.println(e.getMessage() + " (ignoring " + s.getName() + ")");
                }
            });
        }
        catch (ElementNotPermittedInViewException e) {
            System.out.println(e.getMessage() + " (ignoring " + element.getName() + ")");
        }
    }
}

