/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.PerspectivesHolder;
import com.structurizr.PropertyHolder;
import com.structurizr.model.Perspective;
import com.structurizr.util.StringUtils;
import com.structurizr.util.TagUtils;
import com.structurizr.util.Url;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class ModelItem
implements PropertyHolder,
PerspectivesHolder,
Comparable<ModelItem> {
    private String id = "";
    private final Set<String> tags = new LinkedHashSet<String>();
    private String url;
    private Map<String, String> properties = new HashMap<String, String>();
    private final Set<Perspective> perspectives = new TreeSet<Perspective>();

    @JsonIgnore
    public abstract String getCanonicalName();

    @JsonIgnore
    public abstract Set<String> getDefaultTags();

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public String getTags() {
        return TagUtils.toString(this.getTagsAsSet());
    }

    @JsonIgnore
    public Set<String> getTagsAsSet() {
        LinkedHashSet<String> setOfTags = new LinkedHashSet<String>(this.getDefaultTags());
        setOfTags.addAll(this.tags);
        return setOfTags;
    }

    void setTags(String tags) {
        this.tags.clear();
        if (tags == null) {
            return;
        }
        Collections.addAll(this.tags, tags.split(","));
    }

    public void addTags(String ... tags) {
        if (tags == null) {
            return;
        }
        for (String tag : tags) {
            if (tag == null) continue;
            this.tags.add(tag.trim());
        }
    }

    public boolean removeTag(String tag) {
        if (tag != null) {
            return this.tags.remove(tag.trim());
        }
        return false;
    }

    public boolean hasTag(String tag) {
        return this.getTagsAsSet().contains(tag.trim());
    }

    public boolean hasProperty(String name, String value) {
        return this.getProperties().containsKey(name) && this.getProperties().get(name).equals(value);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (StringUtils.isNullOrEmpty(url)) {
            this.url = null;
        } else if (url.startsWith("{workspace}")) {
            this.url = url;
        } else if (url.matches("\\{workspace:\\d+\\}.*")) {
            this.url = url;
        } else if (Url.isUrl(url)) {
            this.url = url;
        } else {
            throw new IllegalArgumentException(url + " is not a valid URL.");
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void addProperty(String name, String value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A property name must be specified.");
        }
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("A property value must be specified.");
        }
        this.properties.put(name, value);
    }

    public void addProperties(Map<String, String> properties) {
        for (String key : properties.keySet()) {
            this.addProperty(key, properties.get(key));
        }
    }

    void setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
    }

    @Override
    public Set<Perspective> getPerspectives() {
        return new TreeSet<Perspective>(this.perspectives);
    }

    void setPerspectives(Set<Perspective> perspectives) {
        this.perspectives.clear();
        if (perspectives == null) {
            return;
        }
        this.perspectives.addAll(perspectives);
    }

    @Override
    public Perspective addPerspective(String name, String description) {
        return this.addPerspective(name, description, "");
    }

    @Override
    public Perspective addPerspective(String name, String description, String value) {
        if (StringUtils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        if (StringUtils.isNullOrEmpty(description)) {
            throw new IllegalArgumentException("A description must be specified.");
        }
        if (this.perspectives.stream().anyMatch(p -> p.getName().equals(name))) {
            throw new IllegalArgumentException("A perspective named \"" + name + "\" already exists.");
        }
        Perspective perspective = new Perspective(name, description, value);
        this.perspectives.add(perspective);
        return perspective;
    }

    public void addPerspectives(Set<Perspective> perspectives) {
        for (Perspective perspective : perspectives) {
            this.addPerspective(perspective.getName(), perspective.getDescription(), perspective.getValue());
        }
    }

    @Override
    public int compareTo(ModelItem modelItem) {
        try {
            int id1 = Integer.parseInt(this.getId());
            int id2 = Integer.parseInt(modelItem.getId());
            return id1 - id2;
        }
        catch (NumberFormatException nfe) {
            return this.getId().compareTo(modelItem.getId());
        }
    }
}

