/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.util;

import com.structurizr.util.StringUtils;
import com.structurizr.util.Url;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final String DATA_URI_PREFIX = "data:";
    public static final String DATA_URI_IMAGE_PNG = "data:image/png;base64,";
    public static final String DATA_URI_IMAGE_JPG = "data:image/jpeg;base64,";
    public static final String DATA_URI_IMAGE_SVG = "data:image/svg+xml;";
    public static final String CONTENT_TYPE_IMAGE_PNG = "image/png";
    public static final String CONTENT_TYPE_IMAGE_JPG = "image/jpeg";
    public static final String CONTENT_TYPE_IMAGE_SVG = "image/svg+xml";

    public static String getContentType(@Nonnull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("A file must be specified.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(file.getCanonicalPath() + " does not exist.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getCanonicalPath() + " is not a file.");
        }
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null || !contentType.startsWith("image/")) {
            throw new IllegalArgumentException(file.getCanonicalPath() + " is not a supported image file.");
        }
        return contentType;
    }

    public static String getContentTypeFromDataUri(String dataUri) {
        if (StringUtils.isNullOrEmpty(dataUri)) {
            throw new IllegalArgumentException("A data URI must be specified.");
        }
        if (dataUri.startsWith(DATA_URI_IMAGE_PNG)) {
            return CONTENT_TYPE_IMAGE_PNG;
        }
        if (dataUri.startsWith(DATA_URI_IMAGE_JPG)) {
            return CONTENT_TYPE_IMAGE_JPG;
        }
        if (dataUri.startsWith(DATA_URI_IMAGE_SVG)) {
            return CONTENT_TYPE_IMAGE_SVG;
        }
        return null;
    }

    public static String getImageAsBase64(@Nonnull File file) throws IOException {
        String contentType = ImageUtils.getContentType(file);
        if (CONTENT_TYPE_IMAGE_SVG.equalsIgnoreCase(contentType)) {
            return Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, contentType.split("/")[1], bos);
        byte[] imageBytes = bos.toByteArray();
        return Base64.getEncoder().encodeToString(imageBytes);
    }

    public static String getImageAsDataUri(File file) throws IOException {
        String contentType = ImageUtils.getContentType(file);
        String base64Content = ImageUtils.getImageAsBase64(file);
        return DATA_URI_PREFIX + contentType + ";base64," + base64Content;
    }

    public static String getSvgAsDataUri(String svg) {
        return "data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(svg.getBytes());
    }

    public static String getPngAsDataUri(byte[] png) {
        return DATA_URI_IMAGE_PNG + Base64.getEncoder().encodeToString(png);
    }

    public static void validateImage(String imageDescriptor) {
        if (StringUtils.isNullOrEmpty(imageDescriptor)) {
            return;
        }
        if (Url.isUrl(imageDescriptor = imageDescriptor.trim())) {
            return;
        }
        if (imageDescriptor.toLowerCase().endsWith(".png") || imageDescriptor.toLowerCase().endsWith(".jpg") || imageDescriptor.toLowerCase().endsWith(".jpeg") || imageDescriptor.toLowerCase().endsWith(".gif") || imageDescriptor.toLowerCase().endsWith(".svg")) {
            return;
        }
        if (imageDescriptor.startsWith(DATA_URI_PREFIX)) {
            if (ImageUtils.isSupportedDataUri(imageDescriptor)) {
                return;
            }
            throw new IllegalArgumentException("Only PNG, JPG, and SVG data URIs are supported: " + imageDescriptor);
        }
        throw new IllegalArgumentException("Expected a URL or data URI");
    }

    public static boolean isSupportedDataUri(String uri) {
        return uri.startsWith(DATA_URI_IMAGE_PNG) || uri.startsWith(DATA_URI_IMAGE_JPG) || uri.startsWith(DATA_URI_IMAGE_SVG);
    }
}

