/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.util;

import com.structurizr.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;

public class Url {
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String HTTP_PROTOCOL = "http://";
    public static final String INTRA_WORKSPACE_URL_PREFIX = "{workspace}";
    public static final String INTER_WORKSPACE_URL_REGEX = "\\{workspace:\\d+\\}.*";

    public static boolean isUrl(String urlAsString) {
        if (!StringUtils.isNullOrEmpty(urlAsString)) {
            try {
                new URL(urlAsString);
                return true;
            }
            catch (MalformedURLException murle) {
                return false;
            }
        }
        return false;
    }

    public static boolean isHttpsUrl(String urlAsString) {
        return Url.isUrl(urlAsString) && urlAsString.toLowerCase().startsWith(HTTPS_PROTOCOL);
    }

    public static boolean isHttpUrl(String urlAsString) {
        return Url.isUrl(urlAsString) && urlAsString.toLowerCase().startsWith(HTTP_PROTOCOL);
    }
}

