/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.PropertyHolder;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ColorScheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractStyle
implements PropertyHolder,
Comparable<AbstractStyle> {
    private String tag;
    private ColorScheme colorScheme = null;
    private Map<String, String> properties = new HashMap<String, String>();

    AbstractStyle() {
    }

    AbstractStyle(String tag) {
        this.tag = tag;
    }

    AbstractStyle(String tag, ColorScheme colorScheme) {
        this.tag = tag;
        this.colorScheme = colorScheme;
    }

    public String getTag() {
        return this.tag;
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void addProperty(String name, String value) {
        if (StringUtils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("A property name must be specified.");
        }
        if (StringUtils.isNullOrEmpty(value)) {
            throw new IllegalArgumentException("A property value must be specified.");
        }
        this.properties.put(name, value);
    }

    void setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
    }

    public String toString() {
        return this.tag + " (" + this.colorScheme + ")";
    }

    @Override
    public int compareTo(AbstractStyle other) {
        if (this.colorScheme == null && other.colorScheme == null) {
            return this.tag.compareTo(other.tag);
        }
        if (this.colorScheme == null) {
            return -1;
        }
        if (other.colorScheme == null) {
            return 1;
        }
        return (this.colorScheme + "/" + this.tag).compareTo(other.colorScheme + "/" + other.tag);
    }
}

