/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.StringUtils;
import com.structurizr.view.AbstractStyle;
import com.structurizr.view.Border;
import com.structurizr.view.Color;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.IconPosition;
import com.structurizr.view.Shape;

public final class ElementStyle
extends AbstractStyle {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer width;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer height;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String background;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String stroke;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer strokeWidth;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String color;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer fontSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Shape shape;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String icon;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private IconPosition iconPosition;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Border border;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer opacity;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean metadata;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean description;

    ElementStyle() {
    }

    public ElementStyle(String tag) {
        super(tag);
    }

    ElementStyle(String tag, ColorScheme colorScheme) {
        super(tag, colorScheme);
    }

    public ElementStyle(String tag, Integer width, Integer height, String background, String color, Integer fontSize) {
        this(tag, width, height, background, color, fontSize, null);
    }

    public ElementStyle(String tag, Integer width, Integer height, String background, String color, Integer fontSize, Shape shape) {
        super(tag);
        this.width = width;
        this.height = height;
        this.setBackground(background);
        this.setColor(color);
        this.fontSize = fontSize;
        this.shape = shape;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public ElementStyle width(int width) {
        this.setWidth(width);
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ElementStyle height(int height) {
        this.setHeight(height);
        return this;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String color) {
        if (Color.isHexColorCode(color)) {
            this.background = color.toLowerCase();
        } else {
            String hexColorCode = Color.fromColorNameToHexColorCode(color);
            if (hexColorCode != null) {
                this.background = hexColorCode.toLowerCase();
            } else {
                throw new IllegalArgumentException(color + " is not a valid hex colour code or HTML colour name.");
            }
        }
    }

    public ElementStyle background(String background) {
        this.setBackground(background);
        return this;
    }

    public String getStroke() {
        return this.stroke;
    }

    public void setStroke(String color) {
        if (Color.isHexColorCode(color)) {
            this.stroke = color.toLowerCase();
        } else {
            String hexColorCode = Color.fromColorNameToHexColorCode(color);
            if (hexColorCode != null) {
                this.stroke = hexColorCode.toLowerCase();
            } else {
                throw new IllegalArgumentException(color + " is not a valid hex colour code or HTML colour name.");
            }
        }
    }

    public ElementStyle stroke(String color) {
        this.setStroke(color);
        return this;
    }

    public Integer getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(Integer strokeWidth) {
        this.strokeWidth = strokeWidth == null ? null : (strokeWidth < 1 ? Integer.valueOf(1) : Integer.valueOf(Math.min(10, strokeWidth)));
    }

    public ElementStyle strokeWidth(Integer strokeWidth) {
        this.setStrokeWidth(strokeWidth);
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        if (Color.isHexColorCode(color)) {
            this.color = color.toLowerCase();
        } else {
            String hexColorCode = Color.fromColorNameToHexColorCode(color);
            if (hexColorCode != null) {
                this.color = hexColorCode.toLowerCase();
            } else {
                throw new IllegalArgumentException(color + " is not a valid hex colour code or HTML colour name.");
            }
        }
    }

    public ElementStyle color(String color) {
        this.setColor(color);
        return this;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public ElementStyle fontSize(int fontSize) {
        this.setFontSize(fontSize);
        return this;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public ElementStyle shape(Shape shape) {
        this.setShape(shape);
        return this;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        if (StringUtils.isNullOrEmpty(icon)) {
            this.icon = null;
        } else {
            ImageUtils.validateImage(icon);
            this.icon = icon.trim();
        }
    }

    public ElementStyle icon(String icon) {
        this.setIcon(icon);
        return this;
    }

    public IconPosition getIconPosition() {
        return this.iconPosition;
    }

    public void setIconPosition(IconPosition iconPosition) {
        this.iconPosition = iconPosition;
    }

    public ElementStyle iconPosition(IconPosition iconPosition) {
        this.setIconPosition(iconPosition);
        return this;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public ElementStyle border(Border border) {
        this.setBorder(border);
        return this;
    }

    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        if (opacity != null) {
            this.opacity = opacity < 0 ? Integer.valueOf(0) : (opacity > 100 ? Integer.valueOf(100) : opacity);
        }
    }

    public ElementStyle opacity(int opacity) {
        this.setOpacity(opacity);
        return this;
    }

    public Boolean getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Boolean metadata) {
        this.metadata = metadata;
    }

    public ElementStyle metadata(boolean metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public Boolean getDescription() {
        return this.description;
    }

    public void setDescription(Boolean description) {
        this.description = description;
    }

    public ElementStyle description(boolean description) {
        this.setDescription(description);
        return this;
    }

    void copyFrom(ElementStyle elementStyle) {
        if (elementStyle.getWidth() != null) {
            this.setWidth(elementStyle.getWidth());
        }
        if (elementStyle.getHeight() != null) {
            this.setHeight(elementStyle.getHeight());
        }
        if (!StringUtils.isNullOrEmpty(elementStyle.getBackground())) {
            this.setBackground(elementStyle.getBackground());
        }
        if (!StringUtils.isNullOrEmpty(elementStyle.getStroke())) {
            this.setStroke(elementStyle.getStroke());
        }
        if (elementStyle.getStrokeWidth() != null) {
            this.setStrokeWidth(elementStyle.getStrokeWidth());
        }
        if (!StringUtils.isNullOrEmpty(elementStyle.getColor())) {
            this.setColor(elementStyle.getColor());
        }
        if (elementStyle.getFontSize() != null) {
            this.setFontSize(elementStyle.getFontSize());
        }
        if (elementStyle.getShape() != null) {
            this.setShape(elementStyle.getShape());
        }
        if (!StringUtils.isNullOrEmpty(elementStyle.getIcon())) {
            this.setIcon(elementStyle.getIcon());
        }
        if (elementStyle.getIconPosition() != null) {
            this.setIconPosition(elementStyle.getIconPosition());
        }
        if (elementStyle.getBorder() != null) {
            this.setBorder(elementStyle.getBorder());
        }
        if (elementStyle.getOpacity() != null) {
            this.setOpacity(elementStyle.getOpacity());
        }
        if (elementStyle.getMetadata() != null) {
            this.setMetadata(elementStyle.getMetadata());
        }
        if (elementStyle.getDescription() != null) {
            this.setDescription(elementStyle.getDescription());
        }
        for (String name : elementStyle.getProperties().keySet()) {
            this.addProperty(name, elementStyle.getProperties().get(name));
        }
    }
}

