/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.util.TagUtils;
import com.structurizr.view.Border;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.LineStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.Routing;
import com.structurizr.view.Shape;
import com.structurizr.view.Theme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public final class Styles {
    public static final String DEFAULT_BACKGROUND_LIGHT = "#ffffff";
    public static final String DEFAULT_COLOR_LIGHT = "#444444";
    public static final String DEFAULT_BACKGROUND_DARK = "#111111";
    public static final String DEFAULT_COLOR_DARK = "#cccccc";
    private Collection<ElementStyle> elements = new TreeSet<ElementStyle>();
    private Collection<RelationshipStyle> relationships = new TreeSet<RelationshipStyle>();
    private final List<Theme> themes = new ArrayList<Theme>();

    public Collection<ElementStyle> getElements() {
        return this.elements;
    }

    public void add(ElementStyle elementStyle) {
        if (elementStyle != null) {
            if (StringUtils.isNullOrEmpty(elementStyle.getTag())) {
                throw new IllegalArgumentException("A tag must be specified.");
            }
            if (this.elements.stream().anyMatch(es -> es.getTag().equals(elementStyle.getTag()) && es.getColorScheme() == elementStyle.getColorScheme())) {
                if (elementStyle.getColorScheme() == null) {
                    throw new IllegalArgumentException("An element style for the tag \"" + elementStyle.getTag() + "\" already exists.");
                }
                throw new IllegalArgumentException("An element style for the tag \"" + elementStyle.getTag() + "\" and color scheme " + elementStyle.getColorScheme() + " already exists.");
            }
            this.elements.add(elementStyle);
        }
    }

    public ElementStyle addElementStyle(String tag) {
        return this.addElementStyle(tag, null);
    }

    public ElementStyle addElementStyle(String tag, ColorScheme colorScheme) {
        ElementStyle elementStyle = new ElementStyle(tag, colorScheme);
        this.add(elementStyle);
        return elementStyle;
    }

    public void clearElementStyles() {
        this.elements = new LinkedList<ElementStyle>();
    }

    public void clearRelationshipStyles() {
        this.relationships = new LinkedList<RelationshipStyle>();
    }

    public Collection<RelationshipStyle> getRelationships() {
        return this.relationships;
    }

    public void add(RelationshipStyle relationshipStyle) {
        if (relationshipStyle != null) {
            if (StringUtils.isNullOrEmpty(relationshipStyle.getTag())) {
                throw new IllegalArgumentException("A tag must be specified.");
            }
            if (this.relationships.stream().anyMatch(rs -> rs.getTag().equals(relationshipStyle.getTag()) && rs.getColorScheme() == relationshipStyle.getColorScheme())) {
                if (relationshipStyle.getColorScheme() == null) {
                    throw new IllegalArgumentException("A relationship style for the tag \"" + relationshipStyle.getTag() + "\" already exists.");
                }
                throw new IllegalArgumentException("A relationship style for the tag \"" + relationshipStyle.getTag() + "\" and color scheme " + relationshipStyle.getColorScheme() + " already exists.");
            }
            this.relationships.add(relationshipStyle);
        }
    }

    public RelationshipStyle addRelationshipStyle(String tag) {
        return this.addRelationshipStyle(tag, null);
    }

    public RelationshipStyle addRelationshipStyle(String tag, ColorScheme colorScheme) {
        RelationshipStyle relationshipStyle = new RelationshipStyle(tag, colorScheme);
        this.add(relationshipStyle);
        return relationshipStyle;
    }

    public ElementStyle getElementStyle(String tag) {
        return this.getElementStyle(tag, null);
    }

    public ElementStyle getElementStyle(String tag, ColorScheme colorScheme) {
        if (StringUtils.isNullOrEmpty(tag)) {
            throw new IllegalArgumentException("A tag must be specified.");
        }
        return this.elements.stream().filter(es -> es.getTag().equals(tag) && es.getColorScheme() == colorScheme).findFirst().orElse(null);
    }

    public ElementStyle findElementStyle(String tag) {
        return this.findElementStyle(tag, ColorScheme.Light);
    }

    public ElementStyle findElementStyle(String tag, ColorScheme colorScheme) {
        if (tag == null) {
            return null;
        }
        boolean elementStyleExists = false;
        tag = tag.trim();
        ElementStyle style = new ElementStyle(tag);
        ArrayList<ElementStyle> elementStyles = new ArrayList<ElementStyle>();
        for (Theme theme : this.themes) {
            elementStyles.addAll(theme.getElements());
        }
        elementStyles.addAll(this.elements);
        for (ElementStyle elementStyle : elementStyles) {
            if (elementStyle == null || !elementStyle.getTag().equals(tag) || elementStyle.getColorScheme() != null && elementStyle.getColorScheme() != colorScheme) continue;
            elementStyleExists = true;
            style.copyFrom(elementStyle);
        }
        if (elementStyleExists) {
            return style;
        }
        return null;
    }

    public RelationshipStyle getRelationshipStyle(String tag) {
        return this.getRelationshipStyle(tag, null);
    }

    public RelationshipStyle getRelationshipStyle(String tag, ColorScheme colorScheme) {
        if (StringUtils.isNullOrEmpty(tag)) {
            throw new IllegalArgumentException("A tag must be specified.");
        }
        return this.relationships.stream().filter(rs -> rs.getTag().equals(tag) && rs.getColorScheme() == colorScheme).findFirst().orElse(null);
    }

    public RelationshipStyle findRelationshipStyle(String tag) {
        return this.findRelationshipStyle(tag, ColorScheme.Light);
    }

    public RelationshipStyle findRelationshipStyle(String tag, ColorScheme colorScheme) {
        if (tag == null) {
            return null;
        }
        boolean relationshipStyleExists = false;
        tag = tag.trim();
        RelationshipStyle style = new RelationshipStyle(tag);
        ArrayList<RelationshipStyle> relationshipStyles = new ArrayList<RelationshipStyle>();
        for (Theme theme : this.themes) {
            relationshipStyles.addAll(theme.getRelationships());
        }
        relationshipStyles.addAll(this.relationships);
        for (RelationshipStyle relationshipStyle : relationshipStyles) {
            if (relationshipStyle == null || !relationshipStyle.getTag().equals(tag) || relationshipStyle.getColorScheme() != null && relationshipStyle.getColorScheme() != colorScheme) continue;
            style.copyFrom(relationshipStyle);
            relationshipStyleExists = true;
        }
        if (relationshipStyleExists) {
            return style;
        }
        return null;
    }

    public ElementStyle findElementStyle(Element element) {
        return this.findElementStyle(element, ColorScheme.Light);
    }

    public ElementStyle findElementStyle(Element element, ColorScheme colorScheme) {
        ElementStyle style = new ElementStyle("Element").shape(Shape.Box).fontSize(24).border(Border.Solid).opacity(100).metadata(true).description(true);
        if (element != null) {
            LinkedHashSet<String> tagsUsedToComposeStyle = new LinkedHashSet<String>();
            tagsUsedToComposeStyle.add("Element");
            Object tags = element.getTags();
            if (element instanceof SoftwareSystemInstance) {
                SoftwareSystem ss = ((SoftwareSystemInstance)element).getSoftwareSystem();
                tags = ss.getTags() + "," + (String)tags;
            } else if (element instanceof ContainerInstance) {
                Container c = ((ContainerInstance)element).getContainer();
                tags = c.getTags() + "," + (String)tags;
            }
            for (String tag : ((String)tags).split(",")) {
                ElementStyle elementStyle;
                if (StringUtils.isNullOrEmpty(tag) || (elementStyle = this.findElementStyle(tag, colorScheme)) == null) continue;
                style.copyFrom(elementStyle);
                tagsUsedToComposeStyle.add(elementStyle.getTag());
            }
            style.setTag(TagUtils.toString(tagsUsedToComposeStyle));
        }
        if (style.getBackground() == null) {
            if (colorScheme == ColorScheme.Dark) {
                style.background(DEFAULT_BACKGROUND_DARK);
                if (style.getStroke() == null) {
                    style.stroke(DEFAULT_COLOR_DARK);
                }
            } else {
                style.background(DEFAULT_BACKGROUND_LIGHT);
                if (style.getStroke() == null) {
                    style.stroke(DEFAULT_COLOR_LIGHT);
                }
            }
        } else if (style.getStroke() == null) {
            Color color = Color.decode(style.getBackground());
            style.setStroke(String.format("#%06X", 0xFFFFFF & color.darker().getRGB()));
        }
        if (style.getColor() == null) {
            if (colorScheme == ColorScheme.Dark) {
                style.color(DEFAULT_COLOR_DARK);
            } else {
                style.color(DEFAULT_COLOR_LIGHT);
            }
        }
        return style;
    }

    public RelationshipStyle findRelationshipStyle(Relationship relationship) {
        return this.findRelationshipStyle(relationship, ColorScheme.Light);
    }

    public RelationshipStyle findRelationshipStyle(Relationship relationship, ColorScheme colorScheme) {
        RelationshipStyle style = new RelationshipStyle("Relationship").thickness(2).style(LineStyle.Dashed).dashed(true).routing(Routing.Direct).fontSize(24).width(200).position(50).opacity(100);
        if (relationship != null) {
            LinkedHashSet<String> tagsUsedToComposeStyle = new LinkedHashSet<String>();
            tagsUsedToComposeStyle.add("Relationship");
            Object tags = relationship.getTags();
            String linkedRelationshipId = relationship.getLinkedRelationshipId();
            while (!StringUtils.isNullOrEmpty(linkedRelationshipId)) {
                Relationship linkedRelationship = relationship.getModel().getRelationship(linkedRelationshipId);
                tags = linkedRelationship.getTags() + "," + (String)tags;
                linkedRelationshipId = linkedRelationship.getLinkedRelationshipId();
            }
            for (String tag : ((String)tags).split(",")) {
                RelationshipStyle relationshipStyle;
                if (StringUtils.isNullOrEmpty(tag) || (relationshipStyle = this.findRelationshipStyle(tag, colorScheme)) == null) continue;
                style.copyFrom(relationshipStyle);
                tagsUsedToComposeStyle.add(relationshipStyle.getTag());
            }
            style.setTag(TagUtils.toString(tagsUsedToComposeStyle));
        }
        if (style.getColor() == null) {
            if (colorScheme == ColorScheme.Dark) {
                style.color(DEFAULT_COLOR_DARK);
            } else {
                style.color(DEFAULT_COLOR_LIGHT);
            }
        }
        return style;
    }

    public void addStylesFromTheme(Theme theme) {
        if (theme != null) {
            this.themes.add(theme);
        }
    }

    public void inlineTheme(Theme theme) {
        for (ElementStyle elementStyle : theme.getElements()) {
            ElementStyle es = this.getElementStyle(elementStyle.getTag());
            if (es == null) {
                es = this.addElementStyle(elementStyle.getTag());
            }
            es.copyFrom(elementStyle);
        }
        for (RelationshipStyle relationshipStyle : theme.getRelationships()) {
            RelationshipStyle rs = this.getRelationshipStyle(relationshipStyle.getTag());
            if (rs == null) {
                rs = this.addRelationshipStyle(relationshipStyle.getTag());
            }
            rs.copyFrom(relationshipStyle);
        }
    }
}

