/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation.importer;

import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.Section;
import com.structurizr.documentation.importer.DocumentationImportException;
import com.structurizr.documentation.importer.DocumentationImporter;
import com.structurizr.documentation.util.FormatFinder;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDocumentationImporter
implements DocumentationImporter {
    @Override
    public void importDocumentation(Documentable documentable, File path) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace or software system must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        try {
            if (path.isDirectory()) {
                Object[] filesInDirectory = path.listFiles();
                if (filesInDirectory != null) {
                    Arrays.sort(filesInDirectory);
                    for (Object file : filesInDirectory) {
                        if (((File)file).isDirectory() || ((File)file).getName().startsWith(".")) continue;
                        this.importFile(documentable, (File)file);
                    }
                }
            } else {
                this.importFile(documentable, path);
            }
        }
        catch (Exception e) {
            throw new DocumentationImportException(e);
        }
    }

    protected void importFile(Documentable documentable, File file) throws Exception {
        if (FormatFinder.isMarkdownOrAsciiDoc(file)) {
            Format format = FormatFinder.findFormat(file);
            String sectionDefinition = "";
            if (format == Format.Markdown) {
                sectionDefinition = "##";
            } else if (format == Format.AsciiDoc) {
                sectionDefinition = "==";
            }
            String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            String sectionName = file.getName();
            Matcher matcher = Pattern.compile("^" + sectionDefinition + " (.*?)$", 8).matcher(content);
            if (matcher.find()) {
                sectionName = matcher.group(1);
            }
            Section section = new Section(sectionName, format, content);
            documentable.getDocumentation().addSection(section);
        }
    }
}

