/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation.template;

import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Documentation;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.Section;
import com.structurizr.documentation.template.FormattedContent;
import com.structurizr.documentation.util.FormatFinder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;

public abstract class DocumentationTemplate {
    protected Documentation documentation;

    public DocumentationTemplate(Documentable documentable) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace or software system must be specified.");
        }
        this.documentation = documentable.getDocumentation();
    }

    public Section addSection(String title, File ... files) throws IOException {
        FormattedContent content = this.readFiles(files);
        Section section = new Section(title, content.getFormat(), content.getContent());
        this.documentation.addSection(section);
        return section;
    }

    public Section addSection(String title, Format format, String content) {
        Section section = new Section(title, format, content);
        this.documentation.addSection(section);
        return section;
    }

    protected FormattedContent readFiles(File ... files) throws IOException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("One or more files must be specified.");
        }
        Format format = Format.Markdown;
        StringBuilder content = new StringBuilder();
        for (File file : files) {
            Object[] filesInDirectory;
            if (file == null) {
                throw new IllegalArgumentException("One or more files must be specified.");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException(file.getCanonicalPath() + " does not exist.");
            }
            if (content.length() > 0) {
                content.append(System.lineSeparator());
            }
            if (file.isFile()) {
                format = FormatFinder.findFormat(file);
                content.append(new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8));
                continue;
            }
            if (!file.isDirectory() || (filesInDirectory = file.listFiles()) == null) continue;
            Arrays.sort(filesInDirectory);
            content.append(this.readFiles((File[])filesInDirectory).getContent());
        }
        return new FormattedContent(content.toString(), format);
    }
}

