/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation.importer;

import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Image;
import com.structurizr.documentation.importer.DocumentationImportException;
import com.structurizr.documentation.importer.DocumentationImporter;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.StringUtils;
import java.io.File;
import java.io.IOException;

public class DefaultImageImporter
implements DocumentationImporter {
    @Override
    public void importDocumentation(Documentable documentable, File path) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace or software system must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        try {
            if (path.isDirectory()) {
                this.importImages(documentable, "", path);
            } else {
                this.importImage(documentable, "", path);
            }
        }
        catch (Exception e) {
            throw new DocumentationImportException(e.getMessage(), e);
        }
    }

    private void importImages(Documentable documentable, String root, File path) throws IOException {
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (file.isDirectory()) {
                    if (StringUtils.isNullOrEmpty((String)root)) {
                        this.importImages(documentable, file.getName(), file);
                        continue;
                    }
                    this.importImages(documentable, root + "/" + file.getName(), file);
                    continue;
                }
                if (!name.endsWith(".png") && !name.endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".gif")) continue;
                this.importImage(documentable, root, file);
            }
        }
    }

    private void importImage(Documentable documentable, String path, File file) throws IOException {
        String contentType = ImageUtils.getContentType((File)file);
        String base64Content = ImageUtils.getImageAsBase64((File)file);
        String name = StringUtils.isNullOrEmpty((String)path) ? file.getName() : path + "/" + file.getName();
        documentable.getDocumentation().addImage(new Image(name, contentType, base64Content));
    }
}

