/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation.importer;

import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Section;
import com.structurizr.documentation.importer.DefaultDocumentationImporter;
import com.structurizr.documentation.importer.DocumentationImportException;
import java.io.File;
import java.util.Arrays;

public class RecursiveDefaultDocumentationImporter
extends DefaultDocumentationImporter {
    @Override
    public void importDocumentation(Documentable documentable, File path) {
        try {
            if (documentable == null) {
                throw new IllegalArgumentException("A workspace or software system must be specified");
            }
            if (path == null) {
                throw new IllegalArgumentException("A path must be specified");
            }
            if (!path.exists()) {
                throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist");
            }
            if (path.isDirectory()) {
                this.importDirectory(documentable, path);
            } else {
                this.importFile(documentable, path);
            }
            for (Section section : documentable.getDocumentation().getSections()) {
                String filename = section.getFilename();
                if ((filename = filename.replace(path.getCanonicalPath(), "")).startsWith("/")) {
                    filename = filename.substring(1);
                }
                section.setFilename(filename);
            }
        }
        catch (Exception e) {
            throw new DocumentationImportException(e);
        }
    }

    private void importDirectory(Documentable documentable, File path) throws Exception {
        Object[] filesInDirectory = path.listFiles();
        if (filesInDirectory != null) {
            Arrays.sort(filesInDirectory);
            for (Object file : filesInDirectory) {
                if (!((File)file).isDirectory() && !((File)file).getName().startsWith(".")) {
                    this.importFile(documentable, (File)file);
                    continue;
                }
                if (!((File)file).isDirectory()) continue;
                this.importDirectory(documentable, (File)file);
            }
        }
    }
}

