/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DeploymentGroup;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;

final class ContainerInstanceParser
extends AbstractParser {
    private static final String GRAMMAR = "containerInstance <identifier> [deploymentGroup|tags] [tags]";
    private static final int IDENTIFIER_INDEX = 1;
    private static final int SECOND_TOKEN = 2;
    private static final int THIRD_TOKEN = 3;

    ContainerInstanceParser() {
    }

    ContainerInstance parse(DeploymentNodeDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: containerInstance <identifier> [deploymentGroup|tags] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: containerInstance <identifier> [deploymentGroup|tags] [tags]");
        }
        String containerIdentifier = tokens.get(1);
        Element element = context.getElement(containerIdentifier);
        if (element == null) {
            throw new RuntimeException("The container \"" + containerIdentifier + "\" does not exist");
        }
        if (element instanceof Container) {
            String token;
            DeploymentNode deploymentNode = context.getDeploymentNode();
            String deploymentGroup = "Default";
            int tagsIndex = 2;
            if (tokens.includes(2) && context.getElement(token = tokens.get(2)) instanceof DeploymentGroup) {
                deploymentGroup = context.getElement(token).getName();
                tagsIndex = 3;
            }
            ContainerInstance containerInstance = deploymentNode.add((Container)element, deploymentGroup);
            if (tokens.includes(tagsIndex)) {
                String tags = tokens.get(tagsIndex);
                containerInstance.addTags(tags.split(","));
            }
            return containerInstance;
        }
        throw new RuntimeException("The element \"" + containerIdentifier + "\" is not a container");
    }
}

