/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Container;
import com.structurizr.model.SoftwareSystem;

final class ContainerParser
extends AbstractParser {
    private static final String GRAMMAR = "container <name> [description] [technology] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    ContainerParser() {
    }

    Container parse(SoftwareSystemDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: container <name> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: container <name> [description] [technology] [tags]");
        }
        String name = tokens.get(1);
        String description = "";
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        String technology = "";
        if (tokens.includes(3)) {
            technology = tokens.get(3);
        }
        SoftwareSystem softwareSystem = context.getSoftwareSystem();
        Container container = softwareSystem.addContainer(name, description, technology);
        if (tokens.includes(4)) {
            String tags = tokens.get(4);
            container.addTags(tags.split(","));
        }
        if (context.hasGroup()) {
            container.setGroup(context.getGroup());
        }
        return container;
    }
}

