/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.CustomViewDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.ViewContentParser;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.view.CustomView;
import java.util.Set;

final class CustomViewContentParser
extends ViewContentParser {
    private static final int FIRST_IDENTIFIER_INDEX = 1;
    private static final int RELATIONSHIP_IDENTIFIER_INDEX = 2;
    private static final String WILDCARD = "*";
    private static final String RELATIONSHIP = "->";

    CustomViewContentParser() {
    }

    void parseInclude(CustomViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: include <*|identifier> [identifier...] or include <*|identifier> -> <*|identifier>");
        }
        CustomView view = context.getCustomView();
        if (tokens.size() == 4 && tokens.get(2).equals(RELATIONSHIP)) {
            String sourceElementIdentifier = tokens.get(1);
            String destinationElementIdentifier = tokens.get(3);
            Set<Relationship> relationships = this.findRelationships(context, sourceElementIdentifier, destinationElementIdentifier);
            for (Relationship relationship : relationships) {
                view.add(relationship);
            }
        } else if (tokens.contains(WILDCARD)) {
            for (CustomElement element : context.getWorkspace().getModel().getCustomElements()) {
                view.add(element);
            }
        } else {
            for (int i = 1; i < tokens.size(); ++i) {
                String identifier = tokens.get(i);
                Element element = context.getElement(identifier);
                Relationship relationship = context.getRelationship(identifier);
                if (element == null && relationship == null) {
                    throw new RuntimeException("The element/relationship \"" + identifier + "\" does not exist");
                }
                if (element != null) {
                    if (element instanceof CustomElement) {
                        view.add((CustomElement)element);
                    } else {
                        throw new RuntimeException("The element \"" + identifier + "\" can not be added to this type of view");
                    }
                }
                if (relationship == null) continue;
                view.add(relationship);
            }
        }
    }

    void parseExclude(CustomViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: exclude <identifier> [identifier...] or exclude <*|identifier> -> <*|identifier>");
        }
        CustomView view = context.getCustomView();
        if (tokens.size() == 4 && tokens.get(2).equals(RELATIONSHIP)) {
            String sourceElementIdentifier = tokens.get(1);
            String destinationElementIdentifier = tokens.get(3);
            Set<Relationship> relationships = this.findRelationships(context, sourceElementIdentifier, destinationElementIdentifier);
            for (Relationship relationship : relationships) {
                view.remove(relationship);
            }
        } else {
            for (int i = 1; i < tokens.size(); ++i) {
                String identifier = tokens.get(i);
                Element element = context.getElement(identifier);
                Relationship relationship = context.getRelationship(identifier);
                if (element == null && relationship == null) {
                    throw new RuntimeException("The element/relationship \"" + identifier + "\" does not exist");
                }
                if (element != null) {
                    if (element instanceof CustomElement) {
                        view.remove((CustomElement)element);
                    } else {
                        throw new RuntimeException("The element \"" + identifier + "\" can not be added to this view");
                    }
                }
                if (relationship == null) continue;
                view.remove(relationship);
            }
        }
    }
}

