/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.IncludedDslContext;
import com.structurizr.dsl.Tokens;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

final class IncludeParser
extends AbstractParser {
    private static final String GRAMMAR = "!include <file>";
    private static final int FILE_INDEX = 1;

    IncludeParser() {
    }

    void parse(IncludedDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !include <file>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !include <file>");
        }
        String filename = tokens.get(1);
        if (context.getParentFile() != null) {
            File file = new File(context.getParentFile().getParent(), filename);
            try {
                if (!file.exists()) {
                    throw new RuntimeException(file.getCanonicalPath() + " could not be found");
                }
                if (file.isDirectory()) {
                    throw new RuntimeException(file.getCanonicalPath() + " should be a single file");
                }
                context.setLines(Files.readAllLines(file.toPath(), StandardCharsets.UTF_8));
                context.setFile(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

