/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.EnterpriseDslContext;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Location;
import com.structurizr.model.Person;

final class PersonParser
extends AbstractParser {
    private static final String GRAMMAR = "person <name> [description] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TAGS_INDEX = 3;

    PersonParser() {
    }

    Person parse(GroupableDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: person <name> [description] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: person <name> [description] [tags]");
        }
        String name = tokens.get(1);
        String description = "";
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        Person person = context.getWorkspace().getModel().addPerson(name, description);
        if (tokens.includes(3)) {
            String tags = tokens.get(3);
            person.addTags(tags.split(","));
        }
        if (context instanceof EnterpriseDslContext) {
            person.setLocation(Location.Internal);
        }
        if (context.hasGroup()) {
            person.setGroup(context.getGroup());
        }
        return person;
    }
}

