/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DeploymentGroup;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;

final class SoftwareSystemInstanceParser
extends AbstractParser {
    private static final String GRAMMAR = "softwareSystemInstance <identifier> [deploymentGroup|tags] [tags]";
    private static final int IDENTIFIER_INDEX = 1;
    private static final int SECOND_TOKEN = 2;
    private static final int THIRD_TOKEN = 3;

    SoftwareSystemInstanceParser() {
    }

    SoftwareSystemInstance parse(DeploymentNodeDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: softwareSystemInstance <identifier> [deploymentGroup|tags] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: softwareSystemInstance <identifier> [deploymentGroup|tags] [tags]");
        }
        String softwareSystemIdentifier = tokens.get(1);
        Element element = context.getElement(softwareSystemIdentifier);
        if (element == null) {
            throw new RuntimeException("The software system \"" + softwareSystemIdentifier + "\" does not exist");
        }
        if (element instanceof SoftwareSystem) {
            String token;
            DeploymentNode deploymentNode = context.getDeploymentNode();
            String deploymentGroup = "Default";
            int tagsIndex = 2;
            if (tokens.includes(2) && context.getElement(token = tokens.get(2)) instanceof DeploymentGroup) {
                deploymentGroup = context.getElement(token).getName();
                tagsIndex = 3;
            }
            SoftwareSystemInstance softwareSystemInstance = deploymentNode.add((SoftwareSystem)element, deploymentGroup);
            if (tokens.includes(tagsIndex)) {
                String tags = tokens.get(tagsIndex);
                softwareSystemInstance.addTags(tags.split(","));
            }
            return softwareSystemInstance;
        }
        throw new RuntimeException("The element \"" + softwareSystemIdentifier + "\" is not a software system");
    }
}

