/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.EnterpriseDslContext;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Location;
import com.structurizr.model.SoftwareSystem;

final class SoftwareSystemParser
extends AbstractParser {
    private static final String GRAMMAR = "softwareSystem <name> [description] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TAGS_INDEX = 3;

    SoftwareSystemParser() {
    }

    SoftwareSystem parse(GroupableDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(3)) {
            throw new RuntimeException("Too many tokens, expected: softwareSystem <name> [description] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: softwareSystem <name> [description] [tags]");
        }
        String name = tokens.get(1);
        String description = "";
        if (tokens.includes(2)) {
            description = tokens.get(2);
        }
        SoftwareSystem softwareSystem = context.getWorkspace().getModel().addSoftwareSystem(name, description);
        if (tokens.includes(3)) {
            String tags = tokens.get(3);
            softwareSystem.addTags(tags.split(","));
        }
        if (context instanceof EnterpriseDslContext) {
            softwareSystem.setLocation(Location.Internal);
        }
        if (context.hasGroup()) {
            softwareSystem.setGroup(context.getGroup());
        }
        return softwareSystem;
    }
}

