/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.StaticViewDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.ViewContentParser;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.ElementNotPermittedInViewException;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.StaticView;
import java.util.Set;

final class StaticViewContentParser
extends ViewContentParser {
    private static final int FIRST_IDENTIFIER_INDEX = 1;
    private static final int RELATIONSHIP_IDENTIFIER_INDEX = 2;
    private static final String WILDCARD = "*";
    private static final String RELATIONSHIP = "->";

    StaticViewContentParser() {
    }

    void parseInclude(StaticViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: include <*|identifier|expression> [identifier|expression...] or include <*|identifier> -> <*|identifier>");
        }
        StaticView view = context.getView();
        if (tokens.size() == 4 && tokens.get(2).equals(RELATIONSHIP)) {
            String sourceElementIdentifier = tokens.get(1);
            String destinationElementIdentifier = tokens.get(3);
            Set<Relationship> relationships = this.findRelationships(context, sourceElementIdentifier, destinationElementIdentifier);
            for (Relationship relationship2 : relationships) {
                context.getView().add(relationship2);
            }
        } else if (tokens.contains(WILDCARD)) {
            view.addDefaultElements();
        } else {
            for (int i = 1; i < tokens.size(); ++i) {
                String[] tags;
                String token = tokens.get(i);
                if (token.startsWith("element.tag==")) {
                    tags = token.substring("element.tag==".length()).split(",");
                    context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof StaticStructureElement).forEach(element -> {
                        if (this.hasAllTags((ModelItem)element, tags)) {
                            this.addElementToView((Element)element, context.getView());
                        }
                    });
                    continue;
                }
                if (token.startsWith("element.tag!=")) {
                    tags = token.substring("element.tag!=".length()).split(",");
                    context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof StaticStructureElement).forEach(element -> {
                        if (!this.hasAllTags((ModelItem)element, tags)) {
                            this.addElementToView((Element)element, context.getView());
                        }
                    });
                    continue;
                }
                if (token.startsWith("relationship.tag==")) {
                    tags = token.substring("relationship.tag==".length()).split(",");
                    context.getWorkspace().getModel().getRelationships().forEach(relationship -> {
                        if (view.isElementInView(relationship.getSource()) && view.isElementInView(relationship.getDestination()) && this.hasAllTags((ModelItem)relationship, tags)) {
                            view.add(relationship);
                        }
                    });
                    continue;
                }
                if (token.startsWith("relationship.tag!=")) {
                    tags = token.substring("relationship.tag!=".length()).split(",");
                    context.getWorkspace().getModel().getRelationships().forEach(relationship -> {
                        if (view.isElementInView(relationship.getSource()) && view.isElementInView(relationship.getDestination()) && !this.hasAllTags((ModelItem)relationship, tags)) {
                            view.add(relationship);
                        }
                    });
                    continue;
                }
                Element element2 = context.getElement(token);
                Relationship relationship3 = context.getRelationship(token);
                if (element2 == null && relationship3 == null) {
                    throw new RuntimeException("The element/relationship \"" + token + "\" does not exist");
                }
                if (element2 != null) {
                    if (element2 instanceof CustomElement) {
                        view.add((CustomElement)element2);
                    } else if (element2 instanceof Person) {
                        view.add((Person)element2);
                    } else if (element2 instanceof SoftwareSystem) {
                        view.add((SoftwareSystem)element2);
                    } else if (element2 instanceof Container && view instanceof ContainerView) {
                        ((ContainerView)view).add((Container)element2);
                    } else if (element2 instanceof Container && view instanceof ComponentView) {
                        ((ComponentView)view).add((Container)element2);
                    } else if (element2 instanceof Component && view instanceof ComponentView) {
                        ((ComponentView)view).add((Component)element2);
                    } else {
                        throw new RuntimeException("The element \"" + token + "\" can not be added to this type of view");
                    }
                }
                if (relationship3 == null) continue;
                view.add(relationship3);
            }
        }
    }

    private void addElementToView(Element element, StaticView view) {
        try {
            if (element instanceof Person) {
                view.add((Person)element);
            } else if (element instanceof SoftwareSystem) {
                view.add((SoftwareSystem)element);
            } else if (element instanceof Container && view instanceof ContainerView) {
                ((ContainerView)view).add((Container)element);
            } else if (element instanceof Container && view instanceof ComponentView) {
                ((ComponentView)view).add((Container)element);
            } else if (element instanceof Component && view instanceof ComponentView) {
                ((ComponentView)view).add((Component)element);
            }
        }
        catch (ElementNotPermittedInViewException elementNotPermittedInViewException) {
            // empty catch block
        }
    }

    private void removeElementFromView(Element element, StaticView view) {
        if (element instanceof Person) {
            view.remove((Person)element);
        } else if (element instanceof SoftwareSystem) {
            view.remove((SoftwareSystem)element);
        } else if (element instanceof Container && view instanceof ContainerView) {
            ((ContainerView)view).remove((Container)element);
        } else if (element instanceof Container && view instanceof ComponentView) {
            ((ComponentView)view).remove((Container)element);
        } else if (element instanceof Component && view instanceof ComponentView) {
            ((ComponentView)view).remove((Component)element);
        }
    }

    private boolean hasAllTags(ModelItem modelItem, String[] tags) {
        boolean result = true;
        for (String tag : tags) {
            result = result && modelItem.hasTag(tag.trim());
        }
        return result;
    }

    void parseExclude(StaticViewDslContext context, Tokens tokens) {
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: exclude <identifier|expression> [identifier|expression...] or exclude <*|identifier> -> <*|identifier>");
        }
        StaticView view = context.getView();
        if (tokens.size() == 4 && tokens.get(2).equals(RELATIONSHIP)) {
            String sourceElementIdentifier = tokens.get(1);
            String destinationElementIdentifier = tokens.get(3);
            Set<Relationship> relationships = this.findRelationships(context, sourceElementIdentifier, destinationElementIdentifier);
            for (Relationship relationship2 : relationships) {
                context.getView().remove(relationship2);
            }
        } else {
            for (int i = 1; i < tokens.size(); ++i) {
                String[] tags;
                String token = tokens.get(i);
                if (token.startsWith("element.tag==")) {
                    tags = token.substring("element.tag==".length()).split(",");
                    view.getElements().stream().map(ElementView::getElement).forEach(element -> {
                        if (this.hasAllTags((ModelItem)element, tags)) {
                            this.removeElementFromView((Element)element, context.getView());
                        }
                    });
                    continue;
                }
                if (token.startsWith("element.tag!=")) {
                    tags = token.substring("element.tag!=".length()).split(",");
                    view.getElements().stream().map(ElementView::getElement).forEach(element -> {
                        if (!this.hasAllTags((ModelItem)element, tags)) {
                            this.removeElementFromView((Element)element, context.getView());
                        }
                    });
                    continue;
                }
                if (token.startsWith("relationship.tag==")) {
                    tags = token.substring("relationship.tag==".length()).split(",");
                    view.getRelationships().stream().map(RelationshipView::getRelationship).forEach(relationship -> {
                        if (this.hasAllTags((ModelItem)relationship, tags)) {
                            view.remove(relationship);
                        }
                    });
                    continue;
                }
                if (token.startsWith("relationship.tag!=")) {
                    tags = token.substring("relationship.tag!=".length()).split(",");
                    view.getRelationships().stream().map(RelationshipView::getRelationship).forEach(relationship -> {
                        if (!this.hasAllTags((ModelItem)relationship, tags)) {
                            view.remove(relationship);
                        }
                    });
                    continue;
                }
                Element element2 = context.getElement(token);
                Relationship relationship3 = context.getRelationship(token);
                if (element2 == null && relationship3 == null) {
                    throw new RuntimeException("The element/relationship \"" + token + "\" does not exist");
                }
                if (element2 != null) {
                    if (element2 instanceof CustomElement) {
                        view.remove((CustomElement)element2);
                    } else if (element2 instanceof Person) {
                        view.remove((Person)element2);
                    } else if (element2 instanceof SoftwareSystem) {
                        view.remove((SoftwareSystem)element2);
                    } else if (element2 instanceof Container && view instanceof ContainerView) {
                        ((ContainerView)view).remove((Container)element2);
                    } else if (element2 instanceof Container && view instanceof ComponentView) {
                        ((ComponentView)view).remove((Container)element2);
                    } else if (element2 instanceof Component && view instanceof ComponentView) {
                        ((ComponentView)view).remove((Component)element2);
                    } else {
                        throw new RuntimeException("The element \"" + token + "\" can not be added to this view");
                    }
                }
                if (relationship3 == null) continue;
                view.remove(relationship3);
            }
        }
    }
}

