/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.dsl.AdrsParser;
import com.structurizr.dsl.AutoLayoutParser;
import com.structurizr.dsl.BrandingDslContext;
import com.structurizr.dsl.BrandingParser;
import com.structurizr.dsl.CommentDslContext;
import com.structurizr.dsl.ComponentDslContext;
import com.structurizr.dsl.ComponentParser;
import com.structurizr.dsl.ComponentViewDslContext;
import com.structurizr.dsl.ComponentViewParser;
import com.structurizr.dsl.ConfigurationDslContext;
import com.structurizr.dsl.Constant;
import com.structurizr.dsl.ConstantParser;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.ContainerInstanceDslContext;
import com.structurizr.dsl.ContainerInstanceParser;
import com.structurizr.dsl.ContainerParser;
import com.structurizr.dsl.ContainerViewDslContext;
import com.structurizr.dsl.ContainerViewParser;
import com.structurizr.dsl.CustomElementDslContext;
import com.structurizr.dsl.CustomElementParser;
import com.structurizr.dsl.CustomViewAnimationDslContext;
import com.structurizr.dsl.CustomViewAnimationStepParser;
import com.structurizr.dsl.CustomViewContentParser;
import com.structurizr.dsl.CustomViewDslContext;
import com.structurizr.dsl.CustomViewParser;
import com.structurizr.dsl.DeploymentEnvironment;
import com.structurizr.dsl.DeploymentEnvironmentDslContext;
import com.structurizr.dsl.DeploymentEnvironmentParser;
import com.structurizr.dsl.DeploymentGroup;
import com.structurizr.dsl.DeploymentGroupParser;
import com.structurizr.dsl.DeploymentNodeDslContext;
import com.structurizr.dsl.DeploymentNodeParser;
import com.structurizr.dsl.DeploymentViewAnimationDslContext;
import com.structurizr.dsl.DeploymentViewAnimationStepParser;
import com.structurizr.dsl.DeploymentViewContentParser;
import com.structurizr.dsl.DeploymentViewDslContext;
import com.structurizr.dsl.DeploymentViewParser;
import com.structurizr.dsl.DocsParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.dsl.DslUtils;
import com.structurizr.dsl.DynamicViewContentParser;
import com.structurizr.dsl.DynamicViewDslContext;
import com.structurizr.dsl.DynamicViewParser;
import com.structurizr.dsl.ElementStyleDslContext;
import com.structurizr.dsl.ElementStyleParser;
import com.structurizr.dsl.EnterpriseDslContext;
import com.structurizr.dsl.EnterpriseParser;
import com.structurizr.dsl.ExplicitRelationshipParser;
import com.structurizr.dsl.FileUtils;
import com.structurizr.dsl.FilteredViewParser;
import com.structurizr.dsl.GroupParser;
import com.structurizr.dsl.GroupableDslContext;
import com.structurizr.dsl.HealthCheckParser;
import com.structurizr.dsl.ImplicitRelationshipParser;
import com.structurizr.dsl.ImpliedRelationshipsParser;
import com.structurizr.dsl.IncludeParser;
import com.structurizr.dsl.IncludedDslContext;
import com.structurizr.dsl.InfrastructureNodeDslContext;
import com.structurizr.dsl.InfrastructureNodeParser;
import com.structurizr.dsl.ModelDslContext;
import com.structurizr.dsl.ModelItemDslContext;
import com.structurizr.dsl.ModelItemParser;
import com.structurizr.dsl.ModelItemPerspectivesDslContext;
import com.structurizr.dsl.ModelItemPropertiesDslContext;
import com.structurizr.dsl.PersonDslContext;
import com.structurizr.dsl.PersonParser;
import com.structurizr.dsl.RelationshipDslContext;
import com.structurizr.dsl.RelationshipStyleDslContext;
import com.structurizr.dsl.RelationshipStyleParser;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.SoftwareSystemInstanceDslContext;
import com.structurizr.dsl.SoftwareSystemInstanceParser;
import com.structurizr.dsl.SoftwareSystemParser;
import com.structurizr.dsl.StaticStructureElementInstanceDslContext;
import com.structurizr.dsl.StaticViewAnimationDslContext;
import com.structurizr.dsl.StaticViewAnimationStepParser;
import com.structurizr.dsl.StaticViewContentParser;
import com.structurizr.dsl.StaticViewDslContext;
import com.structurizr.dsl.StructurizrDslParserException;
import com.structurizr.dsl.StructurizrDslTokens;
import com.structurizr.dsl.StylesDslContext;
import com.structurizr.dsl.SystemContextViewDslContext;
import com.structurizr.dsl.SystemContextViewParser;
import com.structurizr.dsl.SystemLandscapeViewDslContext;
import com.structurizr.dsl.SystemLandscapeViewParser;
import com.structurizr.dsl.TerminologyDslContext;
import com.structurizr.dsl.TerminologyParser;
import com.structurizr.dsl.ThemesParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.UserRoleParser;
import com.structurizr.dsl.UsersDslContext;
import com.structurizr.dsl.ViewParser;
import com.structurizr.dsl.ViewsDslContext;
import com.structurizr.dsl.WorkspaceDslContext;
import com.structurizr.dsl.WorkspaceParser;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.ImpliedRelationshipsStrategy;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.CustomView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.SystemLandscapeView;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StructurizrDslParser
extends StructurizrDslTokens {
    private static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("^\\s*");
    private static final Pattern TOKENS_PATTERN = Pattern.compile("\"((\\\\.|[^\"])*)\"|(\\S+)");
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("\\w+");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^\\s*?(//|#).*$");
    private static final String MULTI_LINE_COMMENT_START_TOKEN = "/*";
    private static final String MULTI_LINE_COMMENT_END_TOKEN = "*/";
    private static final Pattern STRING_SUBSTITUTION_PATTERN = Pattern.compile("(\\$\\{[a-zA-Z0-9-_.]+?})");
    private Stack<DslContext> contextStack;
    private Map<String, Element> elements;
    private Map<String, Relationship> relationships;
    private Map<String, Constant> constants;
    private List<String> dslSourceLines = new ArrayList<String>();
    private Workspace workspace;
    private boolean restricted = false;

    public StructurizrDslParser() {
        this.contextStack = new Stack();
        this.elements = new HashMap<String, Element>();
        this.relationships = new HashMap<String, Relationship>();
        this.constants = new HashMap<String, Constant>();
        this.workspace = new Workspace("Name", "Description");
        this.workspace.getModel().setImpliedRelationshipsStrategy((ImpliedRelationshipsStrategy)new CreateImpliedRelationshipsUnlessAnyRelationshipExistsStrategy());
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public Workspace getWorkspace() {
        DslUtils.setDsl(this.workspace, this.getParsedDsl());
        return this.workspace;
    }

    private String getParsedDsl() {
        StringBuilder buf = new StringBuilder();
        for (String line : this.dslSourceLines) {
            buf.append(line);
            buf.append(System.lineSeparator());
        }
        return buf.toString();
    }

    public void parse(File path) throws StructurizrDslParserException {
        if (path == null) {
            throw new RuntimeException("A file must be specified");
        }
        if (!path.exists()) {
            throw new RuntimeException("The file at " + path.getAbsolutePath() + " does not exist");
        }
        List<File> files = FileUtils.findFiles(path);
        try {
            for (File file : files) {
                this.parse(Files.readAllLines(file.toPath(), StandardCharsets.UTF_8), file);
            }
        }
        catch (IOException e) {
            throw new StructurizrDslParserException(e.getMessage());
        }
    }

    public void parse(String dsl) throws StructurizrDslParserException {
        if (StringUtils.isNullOrEmpty((String)dsl)) {
            throw new RuntimeException("A DSL fragment must be specified");
        }
        List<String> lines = Arrays.asList(dsl.split("\\r?\\n"));
        this.parse(lines, new File("."));
    }

    void parse(List<String> lines, File file) throws StructurizrDslParserException {
        int lineNumber = 1;
        for (String line : lines) {
            boolean includeInDslSourceLines = true;
            try {
                if (!EMPTY_LINE_PATTERN.matcher(line).matches() && !COMMENT_PATTERN.matcher(line).matches()) {
                    ArrayList<String> listOfTokens = new ArrayList<String>();
                    Matcher m = TOKENS_PATTERN.matcher(line.trim());
                    while (m.find()) {
                        String token = null;
                        token = m.group(1) != null ? m.group(1) : m.group(3);
                        if (token == null) continue;
                        token = this.substituteStrings(token);
                        listOfTokens.add(token);
                    }
                    Tokens tokens = new Tokens(listOfTokens);
                    String identifier = null;
                    if (tokens.size() > 3 && "=".equals(tokens.get(1))) {
                        identifier = tokens.get(0).toLowerCase();
                        this.validateIdentifier(identifier);
                        tokens = new Tokens(listOfTokens.subList(2, listOfTokens.size()));
                    }
                    String firstToken = tokens.get(0);
                    if (!line.trim().startsWith(MULTI_LINE_COMMENT_START_TOKEN) || !line.trim().endsWith(MULTI_LINE_COMMENT_END_TOKEN)) {
                        if (firstToken.startsWith(MULTI_LINE_COMMENT_START_TOKEN)) {
                            this.startContext(new CommentDslContext());
                        } else if (this.inContext(CommentDslContext.class) && line.trim().endsWith(MULTI_LINE_COMMENT_END_TOKEN)) {
                            this.endContext();
                        } else if (!this.inContext(CommentDslContext.class)) {
                            CustomView view;
                            String group;
                            Relationship relationship;
                            if ("}".equals(tokens.get(0))) {
                                this.endContext();
                            } else if (tokens.size() > 2 && "->".equals(tokens.get(1)) && (this.inContext(ModelDslContext.class) || this.inContext(EnterpriseDslContext.class) || this.inContext(CustomElementDslContext.class) || this.inContext(PersonDslContext.class) || this.inContext(SoftwareSystemDslContext.class) || this.inContext(ContainerDslContext.class) || this.inContext(ComponentDslContext.class) || this.inContext(DeploymentEnvironmentDslContext.class) || this.inContext(DeploymentNodeDslContext.class) || this.inContext(InfrastructureNodeDslContext.class) || this.inContext(SoftwareSystemInstanceDslContext.class) || this.inContext(ContainerInstanceDslContext.class))) {
                                relationship = new ExplicitRelationshipParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new RelationshipDslContext(relationship));
                                }
                                if (identifier != null) {
                                    this.relationships.put(identifier, relationship);
                                }
                            } else if (tokens.size() >= 2 && "->".equals(tokens.get(0)) && (this.inContext(CustomElementDslContext.class) || this.inContext(PersonDslContext.class) || this.inContext(SoftwareSystemDslContext.class) || this.inContext(ContainerDslContext.class) || this.inContext(ComponentDslContext.class) || this.inContext(DeploymentNodeDslContext.class) || this.inContext(InfrastructureNodeDslContext.class) || this.inContext(SoftwareSystemInstanceDslContext.class) || this.inContext(ContainerInstanceDslContext.class))) {
                                relationship = new ImplicitRelationshipParser().parse(this.getContext(ModelItemDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new RelationshipDslContext(relationship));
                                }
                                if (identifier != null) {
                                    this.relationships.put(identifier, relationship);
                                }
                            } else if ("element".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                CustomElement customElement = new CustomElementParser().parse(this.getContext(GroupableDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new CustomElementDslContext(customElement));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)customElement);
                                }
                            } else if ("person".equalsIgnoreCase(firstToken) && (this.inContext(ModelDslContext.class) || this.inContext(EnterpriseDslContext.class))) {
                                Person person = new PersonParser().parse(this.getContext(GroupableDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new PersonDslContext(person));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)person);
                                }
                            } else if ("softwareSystem".equalsIgnoreCase(firstToken) && (this.inContext(ModelDslContext.class) || this.inContext(EnterpriseDslContext.class))) {
                                SoftwareSystem softwareSystem = new SoftwareSystemParser().parse(this.getContext(GroupableDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new SoftwareSystemDslContext(softwareSystem));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)softwareSystem);
                                }
                            } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class)) {
                                Container container = new ContainerParser().parse(this.getContext(SoftwareSystemDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new ContainerDslContext(container));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)container);
                                }
                            } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class)) {
                                Component component = new ComponentParser().parse(this.getContext(ContainerDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new ComponentDslContext(component));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)component);
                                }
                            } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class) && !this.getContext(ModelDslContext.class).hasGroup()) {
                                group = new GroupParser().parse(tokens.withoutContextStartToken());
                                this.startContext(new ModelDslContext(group));
                            } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(EnterpriseDslContext.class) && !this.getContext(EnterpriseDslContext.class).hasGroup()) {
                                group = new GroupParser().parse(tokens.withoutContextStartToken());
                                this.startContext(new EnterpriseDslContext(group));
                            } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class) && !this.getContext(SoftwareSystemDslContext.class).hasGroup()) {
                                group = new GroupParser().parse(tokens.withoutContextStartToken());
                                SoftwareSystem softwareSystem = this.getContext(SoftwareSystemDslContext.class).getSoftwareSystem();
                                this.startContext(new SoftwareSystemDslContext(softwareSystem, group));
                            } else if ("group".equalsIgnoreCase(firstToken) && this.inContext(ContainerDslContext.class) && !this.getContext(ContainerDslContext.class).hasGroup()) {
                                group = new GroupParser().parse(tokens.withoutContextStartToken());
                                Container container = this.getContext(ContainerDslContext.class).getContainer();
                                this.startContext(new ContainerDslContext(container, group));
                            } else if ("url".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class)) {
                                new ModelItemParser().parseUrl(this.getContext(ModelItemDslContext.class), tokens);
                            } else if ("properties".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class)) {
                                this.startContext(new ModelItemPropertiesDslContext(this.getContext(ModelItemDslContext.class).getModelItem()));
                            } else if (this.inContext(ModelItemPropertiesDslContext.class)) {
                                new ModelItemParser().parseProperty(this.getContext(ModelItemPropertiesDslContext.class), tokens);
                            } else if ("perspectives".equalsIgnoreCase(firstToken) && this.inContext(ModelItemDslContext.class)) {
                                this.startContext(new ModelItemPerspectivesDslContext(this.getContext(ModelItemDslContext.class).getModelItem()));
                            } else if (this.inContext(ModelItemPerspectivesDslContext.class)) {
                                new ModelItemParser().parsePerspective(this.getContext(ModelItemPerspectivesDslContext.class), tokens);
                            } else if ("workspace".equalsIgnoreCase(firstToken) && this.contextStack.empty()) {
                                new WorkspaceParser().parse(this.workspace, tokens.withoutContextStartToken());
                                this.startContext(new WorkspaceDslContext());
                            } else if ("impliedRelationships".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                new ImpliedRelationshipsParser().parse(this.getContext(), tokens);
                            } else if ("model".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                this.startContext(new ModelDslContext());
                            } else if ("views".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                this.startContext(new ViewsDslContext());
                            } else if ("branding".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                this.startContext(new BrandingDslContext(file));
                            } else if ("logo".equalsIgnoreCase(firstToken) && this.inContext(BrandingDslContext.class)) {
                                if (!this.restricted) {
                                    new BrandingParser().parseLogo(this.getContext(BrandingDslContext.class), tokens);
                                }
                            } else if ("font".equalsIgnoreCase(firstToken) && this.inContext(BrandingDslContext.class)) {
                                new BrandingParser().parseFont(this.getContext(BrandingDslContext.class), tokens);
                            } else if ("styles".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                this.startContext(new StylesDslContext());
                            } else if ("element".equalsIgnoreCase(firstToken) && this.inContext(StylesDslContext.class)) {
                                ElementStyle elementStyle = new ElementStyleParser().parseElementStyle(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new ElementStyleDslContext(elementStyle, file));
                            } else if ("background".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseBackground(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if (("colour".equalsIgnoreCase(firstToken) || "color".equalsIgnoreCase(firstToken)) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseColour(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("stroke".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseStroke(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("shape".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseShape(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("border".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseBorder(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("opacity".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseOpacity(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("width".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseWidth(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("height".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseHeight(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("fontSize".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseFontSize(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("metadata".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseMetadata(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("description".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                new ElementStyleParser().parseDescription(this.getContext(ElementStyleDslContext.class), tokens);
                            } else if ("icon".equalsIgnoreCase(firstToken) && this.inContext(ElementStyleDslContext.class)) {
                                if (!this.restricted) {
                                    new ElementStyleParser().parseIcon(this.getContext(ElementStyleDslContext.class), tokens);
                                }
                            } else if ("relationship".equalsIgnoreCase(firstToken) && this.inContext(StylesDslContext.class)) {
                                RelationshipStyle relationshipStyle = new RelationshipStyleParser().parseRelationshipStyle(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new RelationshipStyleDslContext(relationshipStyle));
                            } else if ("thickness".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parseThickness(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if (("colour".equalsIgnoreCase(firstToken) || "color".equalsIgnoreCase(firstToken)) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parseColour(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if ("dashed".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parseDashed(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if ("opacity".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parseOpacity(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if ("width".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parseWidth(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if ("fontSize".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parseFontSize(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if ("position".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parsePosition(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if ("routing".equalsIgnoreCase(firstToken) && this.inContext(RelationshipStyleDslContext.class)) {
                                new RelationshipStyleParser().parseRouting(this.getContext(RelationshipStyleDslContext.class), tokens);
                            } else if ("enterprise".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                new EnterpriseParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new EnterpriseDslContext());
                            } else if ("deploymentEnvironment".equalsIgnoreCase(firstToken) && this.inContext(ModelDslContext.class)) {
                                String environment = new DeploymentEnvironmentParser().parse(tokens.withoutContextStartToken());
                                this.startContext(new DeploymentEnvironmentDslContext(environment));
                                if (identifier != null) {
                                    DeploymentEnvironment deploymentEnvironment = new DeploymentEnvironment(environment);
                                    this.elements.put(identifier, deploymentEnvironment);
                                }
                            } else if ("deploymentGroup".equalsIgnoreCase(firstToken) && this.inContext(DeploymentEnvironmentDslContext.class)) {
                                group = new DeploymentGroupParser().parse(tokens.withoutContextStartToken());
                                if (identifier != null) {
                                    DeploymentGroup deploymentGroup = new DeploymentGroup(group);
                                    this.elements.put(identifier, deploymentGroup);
                                }
                            } else if ("deploymentNode".equalsIgnoreCase(firstToken) && (this.inContext(DeploymentEnvironmentDslContext.class) || this.inContext(DeploymentNodeDslContext.class))) {
                                DeploymentNode deploymentNode = new DeploymentNodeParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new DeploymentNodeDslContext(deploymentNode));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)deploymentNode);
                                }
                            } else if ("infrastructureNode".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                InfrastructureNode infrastructureNode = new InfrastructureNodeParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new InfrastructureNodeDslContext(infrastructureNode));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)infrastructureNode);
                                }
                            } else if ("softwareSystemInstance".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                SoftwareSystemInstance softwareSystemInstance = new SoftwareSystemInstanceParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new SoftwareSystemInstanceDslContext(softwareSystemInstance));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)softwareSystemInstance);
                                }
                            } else if ("containerInstance".equalsIgnoreCase(firstToken) && this.inContext(DeploymentNodeDslContext.class)) {
                                ContainerInstance containerInstance = new ContainerInstanceParser().parse(this.getContext(DeploymentNodeDslContext.class), tokens.withoutContextStartToken());
                                if (this.shouldStartContext(tokens)) {
                                    this.startContext(new ContainerInstanceDslContext(containerInstance));
                                }
                                if (identifier != null) {
                                    this.elements.put(identifier, (Element)containerInstance);
                                }
                            } else if ("healthCheck".equalsIgnoreCase(firstToken) && this.inContext(StaticStructureElementInstanceDslContext.class)) {
                                new HealthCheckParser().parse(this.getContext(StaticStructureElementInstanceDslContext.class), tokens.withoutContextStartToken());
                            } else if ("custom".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                view = new CustomViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new CustomViewDslContext(view));
                            } else if ("systemLandscape".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                view = new SystemLandscapeViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new SystemLandscapeViewDslContext((SystemLandscapeView)view));
                            } else if ("systemContext".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                view = new SystemContextViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new SystemContextViewDslContext((SystemContextView)view));
                            } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                view = new ContainerViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new ContainerViewDslContext((ContainerView)view));
                            } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                view = new ComponentViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new ComponentViewDslContext((ComponentView)view));
                            } else if ("dynamic".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                view = new DynamicViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new DynamicViewDslContext((DynamicView)view));
                            } else if ("deployment".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                view = new DeploymentViewParser().parse(this.getContext(), tokens.withoutContextStartToken());
                                this.startContext(new DeploymentViewDslContext((DeploymentView)view));
                            } else if ("filtered".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                new FilteredViewParser().parse(this.getContext(), tokens);
                            } else if (tokens.size() > 2 && "->".equals(tokens.get(1)) && this.inContext(DynamicViewDslContext.class)) {
                                new DynamicViewContentParser().parseRelationship(this.getContext(DynamicViewDslContext.class), tokens);
                            } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                new CustomViewContentParser().parseInclude(this.getContext(CustomViewDslContext.class), tokens);
                            } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                new CustomViewContentParser().parseExclude(this.getContext(CustomViewDslContext.class), tokens);
                            } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                new CustomViewAnimationStepParser().parse(this.getContext(CustomViewDslContext.class), tokens);
                            } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                this.startContext(new CustomViewAnimationDslContext(this.getContext(CustomViewDslContext.class).getCustomView()));
                            } else if (this.inContext(CustomViewAnimationDslContext.class)) {
                                new CustomViewAnimationStepParser().parse(this.getContext(CustomViewAnimationDslContext.class), tokens);
                            } else if ("autolayout".equalsIgnoreCase(firstToken) && this.inContext(CustomViewDslContext.class)) {
                                new AutoLayoutParser().parse(this.getContext(CustomViewDslContext.class), tokens);
                            } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                new StaticViewContentParser().parseInclude(this.getContext(StaticViewDslContext.class), tokens);
                            } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                new StaticViewContentParser().parseExclude(this.getContext(StaticViewDslContext.class), tokens);
                            } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                new StaticViewAnimationStepParser().parse(this.getContext(StaticViewDslContext.class), tokens);
                            } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                this.startContext(new StaticViewAnimationDslContext(this.getContext(StaticViewDslContext.class).getView()));
                            } else if (this.inContext(StaticViewAnimationDslContext.class)) {
                                new StaticViewAnimationStepParser().parse(this.getContext(StaticViewAnimationDslContext.class), tokens);
                            } else if ("include".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                new DeploymentViewContentParser().parseInclude(this.getContext(DeploymentViewDslContext.class), tokens);
                            } else if ("exclude".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                new DeploymentViewContentParser().parseExclude(this.getContext(DeploymentViewDslContext.class), tokens);
                            } else if ("animationStep".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                new DeploymentViewAnimationStepParser().parse(this.getContext(DeploymentViewDslContext.class), tokens);
                            } else if ("animation".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                this.startContext(new DeploymentViewAnimationDslContext(this.getContext(DeploymentViewDslContext.class).getView()));
                            } else if (this.inContext(DeploymentViewAnimationDslContext.class)) {
                                new DeploymentViewAnimationStepParser().parse(this.getContext(DeploymentViewAnimationDslContext.class), tokens);
                            } else if ("autolayout".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                new AutoLayoutParser().parse(this.getContext(StaticViewDslContext.class), tokens);
                            } else if ("autolayout".equalsIgnoreCase(firstToken) && this.inContext(DynamicViewDslContext.class)) {
                                new AutoLayoutParser().parse(this.getContext(DynamicViewDslContext.class), tokens);
                            } else if ("autolayout".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                new AutoLayoutParser().parse(this.getContext(DeploymentViewDslContext.class), tokens);
                            } else if ("title".equalsIgnoreCase(firstToken) && this.inContext(StaticViewDslContext.class)) {
                                new ViewParser().parseTitle(this.getContext(StaticViewDslContext.class), tokens);
                            } else if ("title".equalsIgnoreCase(firstToken) && this.inContext(DynamicViewDslContext.class)) {
                                new ViewParser().parseTitle(this.getContext(DynamicViewDslContext.class), tokens);
                            } else if ("title".equalsIgnoreCase(firstToken) && this.inContext(DeploymentViewDslContext.class)) {
                                new ViewParser().parseTitle(this.getContext(DeploymentViewDslContext.class), tokens);
                            } else if ("themes".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                new ThemesParser().parse(this.getContext(), tokens);
                            } else if ("terminology".equalsIgnoreCase(firstToken) && this.inContext(ViewsDslContext.class)) {
                                this.startContext(new TerminologyDslContext());
                            } else if ("enterprise".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parseEnterprise(this.getContext(), tokens);
                            } else if ("person".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parsePerson(this.getContext(), tokens);
                            } else if ("softwareSystem".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parseSoftwareSystem(this.getContext(), tokens);
                            } else if ("container".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parseContainer(this.getContext(), tokens);
                            } else if ("component".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parseComponent(this.getContext(), tokens);
                            } else if ("deploymentNode".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parseDeploymentNode(this.getContext(), tokens);
                            } else if ("infrastructureNode".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parseInfrastructureNode(this.getContext(), tokens);
                            } else if ("relationship".equalsIgnoreCase(firstToken) && this.inContext(TerminologyDslContext.class)) {
                                new TerminologyParser().parseRelationship(this.getContext(), tokens);
                            } else if ("configuration".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                this.startContext(new ConfigurationDslContext());
                            } else if ("users".equalsIgnoreCase(firstToken) && this.inContext(ConfigurationDslContext.class)) {
                                this.startContext(new UsersDslContext());
                            } else if (this.inContext(UsersDslContext.class)) {
                                new UserRoleParser().parse(this.getContext(), tokens);
                            } else if ("!include".equalsIgnoreCase(firstToken)) {
                                if (!this.restricted) {
                                    IncludedDslContext context = new IncludedDslContext(file);
                                    new IncludeParser().parse(context, tokens);
                                    this.parse(context.getLines(), context.getFile());
                                    includeInDslSourceLines = false;
                                }
                            } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                if (!this.restricted) {
                                    new DocsParser().parse(this.getContext(WorkspaceDslContext.class), file, tokens);
                                }
                            } else if ("!docs".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class)) {
                                if (!this.restricted) {
                                    new DocsParser().parse(this.getContext(SoftwareSystemDslContext.class), file, tokens);
                                }
                            } else if ("!adrs".equalsIgnoreCase(firstToken) && this.inContext(WorkspaceDslContext.class)) {
                                if (!this.restricted) {
                                    new AdrsParser().parse(this.getContext(WorkspaceDslContext.class), file, tokens);
                                }
                            } else if ("!adrs".equalsIgnoreCase(firstToken) && this.inContext(SoftwareSystemDslContext.class)) {
                                if (!this.restricted) {
                                    new AdrsParser().parse(this.getContext(SoftwareSystemDslContext.class), file, tokens);
                                }
                            } else if ("!constant".equalsIgnoreCase(firstToken)) {
                                Constant constant = new ConstantParser().parse(this.getContext(), tokens);
                                this.constants.put(constant.getName(), constant);
                            } else {
                                throw new StructurizrDslParserException("Unexpected tokens");
                            }
                        }
                    }
                }
                if (includeInDslSourceLines) {
                    this.dslSourceLines.add(line);
                }
                ++lineNumber;
            }
            catch (Exception e) {
                throw new StructurizrDslParserException(e.getMessage(), lineNumber, line);
            }
        }
    }

    private String substituteStrings(String token) {
        Matcher m = STRING_SUBSTITUTION_PATTERN.matcher(token);
        while (m.find()) {
            String environmentVariable;
            String before = m.group(0);
            String after = null;
            String name = before.substring(2, before.length() - 1);
            if (this.constants.containsKey(name)) {
                after = this.constants.get(name).getValue();
            } else if (!this.restricted && (environmentVariable = System.getenv().get(name)) != null) {
                after = environmentVariable;
            }
            if (after == null) continue;
            token = token.replace(before, after);
        }
        return token;
    }

    private boolean shouldStartContext(Tokens tokens) {
        return "{".equalsIgnoreCase(tokens.get(tokens.size() - 1));
    }

    private void startContext(DslContext context) {
        context.setWorkspace(this.workspace);
        context.setElements(this.elements);
        context.setRelationships(this.relationships);
        this.contextStack.push(context);
    }

    private DslContext getContext() {
        if (!this.contextStack.empty()) {
            return this.contextStack.peek();
        }
        return null;
    }

    private <T> T getContext(Class<T> clazz) {
        if (this.inContext(clazz)) {
            return (T)this.contextStack.peek();
        }
        throw new RuntimeException("Expected " + clazz.getName() + " but got " + this.contextStack.peek().getClass().getName());
    }

    private void endContext() {
        if (this.contextStack.empty()) {
            throw new RuntimeException("Unexpected end of context");
        }
        DslContext context = this.contextStack.pop();
        context.end();
    }

    private void validateIdentifier(String identifier) {
        if (this.elements.containsKey(identifier) || this.relationships.containsKey(identifier)) {
            throw new RuntimeException("The identifier \"" + identifier + "\" is already in use");
        }
        if (!IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            throw new RuntimeException("Identifiers can only contain the following characters: a-zA-Z_0-9");
        }
    }

    private boolean inContext(Class clazz) {
        if (this.contextStack.empty()) {
            return false;
        }
        return clazz.isAssignableFrom(this.contextStack.peek().getClass());
    }
}

