/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.CustomViewDslContext;
import com.structurizr.dsl.DeploymentViewDslContext;
import com.structurizr.dsl.DynamicViewDslContext;
import com.structurizr.dsl.StaticViewDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.view.AutomaticLayout;
import com.structurizr.view.View;
import java.util.HashMap;
import java.util.Map;

final class AutoLayoutParser
extends AbstractParser {
    private static final int DEFAULT_RANK_SEPARATION = 300;
    private static final int DEFAULT_NODE_SEPARATION = 300;
    private static final int RANK_DIRECTION_INDEX = 1;
    private static final int RANK_SEPARATION_INDEX = 2;
    private static final int NODE_SEPARATION_INDEX = 3;
    private static Map<String, AutomaticLayout.RankDirection> RANK_DIRECTIONS = new HashMap<String, AutomaticLayout.RankDirection>();

    AutoLayoutParser() {
    }

    void parse(CustomViewDslContext context, Tokens tokens) {
        this.parse(context.getView(), tokens);
    }

    void parse(StaticViewDslContext context, Tokens tokens) {
        this.parse((View)context.getView(), tokens);
    }

    void parse(DynamicViewDslContext context, Tokens tokens) {
        this.parse((View)context.getView(), tokens);
    }

    void parse(DeploymentViewDslContext context, Tokens tokens) {
        this.parse((View)context.getView(), tokens);
    }

    private void parse(View view, Tokens tokens) {
        if (view != null) {
            AutomaticLayout.RankDirection rankDirection = AutomaticLayout.RankDirection.TopBottom;
            int rankSeparation = 300;
            int nodeSeparation = 300;
            if (tokens.includes(1)) {
                String rankDirectionAsString = tokens.get(1);
                if (RANK_DIRECTIONS.containsKey(rankDirectionAsString)) {
                    rankDirection = RANK_DIRECTIONS.get(rankDirectionAsString);
                } else {
                    throw new RuntimeException("Valid rank directions are: tb|bt|lr|rl");
                }
            }
            if (tokens.includes(2)) {
                String rankSeparationAsString = tokens.get(2);
                try {
                    rankSeparation = Integer.parseInt(rankSeparationAsString);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Rank separation must be positive integer in pixels");
                }
            }
            if (tokens.includes(3)) {
                String nodeSeparationAsString = tokens.get(3);
                try {
                    nodeSeparation = Integer.parseInt(nodeSeparationAsString);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Node separation must be positive integer in pixels");
                }
            }
            view.enableAutomaticLayout(rankDirection, rankSeparation, nodeSeparation);
        }
    }

    static {
        RANK_DIRECTIONS.put("tb", AutomaticLayout.RankDirection.TopBottom);
        RANK_DIRECTIONS.put("bt", AutomaticLayout.RankDirection.BottomTop);
        RANK_DIRECTIONS.put("lr", AutomaticLayout.RankDirection.LeftRight);
        RANK_DIRECTIONS.put("rl", AutomaticLayout.RankDirection.RightLeft);
    }
}

