/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.ContainerDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;

final class ComponentParser
extends AbstractParser {
    private static final String GRAMMAR = "component <name> [description] [technology] [tags]";
    private static final int NAME_INDEX = 1;
    private static final int DESCRIPTION_INDEX = 2;
    private static final int TECHNOLOGY_INDEX = 3;
    private static final int TAGS_INDEX = 4;

    ComponentParser() {
    }

    Component parse(ContainerDslContext context, Tokens tokens) {
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: component <name> [description] [technology] [tags]");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: component <name> [description] [technology] [tags]");
        }
        Container container = context.getContainer();
        Component component = null;
        String name = tokens.get(1);
        if (context.isExtendingWorkspace()) {
            component = container.getComponentWithName(name);
        }
        if (component == null) {
            component = container.addComponent(name);
        }
        if (tokens.includes(2)) {
            String description = tokens.get(2);
            component.setDescription(description);
        }
        if (tokens.includes(3)) {
            String technology = tokens.get(3);
            component.setTechnology(technology);
        }
        if (tokens.includes(4)) {
            String tags = tokens.get(4);
            component.addTags(tags.split(","));
        }
        if (context.hasGroup()) {
            component.setGroup(context.getGroup().getName());
            context.getGroup().addElement((Element)component);
        }
        return component;
    }
}

