/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractExpressionParser;
import com.structurizr.dsl.DslContext;
import com.structurizr.model.CustomElement;
import com.structurizr.model.Element;
import java.util.LinkedHashSet;
import java.util.Set;

final class CustomViewExpressionParser
extends AbstractExpressionParser {
    CustomViewExpressionParser() {
    }

    @Override
    protected Set<Element> evaluateElementTypeExpression(String expr, DslContext context) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        String type = expr.substring("element.type==".length());
        switch (type.toLowerCase()) {
            case "custom": {
                context.getWorkspace().getModel().getElements().stream().filter(e -> e instanceof CustomElement).forEach(elements::add);
                break;
            }
            default: {
                throw new RuntimeException("The element type of \"" + type + "\" is not valid for this view");
            }
        }
        return elements;
    }

    @Override
    protected Set<Element> findAfferentCouplings(Element element) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        elements.addAll(this.findAfferentCouplings(element, CustomElement.class));
        return elements;
    }

    @Override
    protected Set<Element> findEfferentCouplings(Element element) {
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        elements.addAll(this.findEfferentCouplings(element, CustomElement.class));
        return elements;
    }
}

