/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.Workspace;
import com.structurizr.documentation.AutomaticDocumentationTemplate;
import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.SoftwareSystemDslContext;
import com.structurizr.dsl.Tokens;
import com.structurizr.dsl.WorkspaceDslContext;
import com.structurizr.model.SoftwareSystem;
import java.io.File;
import java.io.IOException;

final class DocsParser
extends AbstractParser {
    private static final String GRAMMAR = "!docs <path>";
    private static final int PATH_INDEX = 1;

    DocsParser() {
    }

    void parse(WorkspaceDslContext context, File file, Tokens tokens) {
        this.parse(context.getWorkspace(), null, file, tokens);
    }

    void parse(SoftwareSystemDslContext context, File file, Tokens tokens) {
        this.parse(context.getWorkspace(), context.getSoftwareSystem(), file, tokens);
    }

    private void parse(Workspace workspace, SoftwareSystem softwareSystem, File file, Tokens tokens) {
        if (tokens.hasMoreThan(1)) {
            throw new RuntimeException("Too many tokens, expected: !docs <path>");
        }
        if (!tokens.includes(1)) {
            throw new RuntimeException("Expected: !docs <path>");
        }
        if (file != null) {
            File path = new File(file.getParentFile(), tokens.get(1));
            if (!path.exists()) {
                throw new RuntimeException("Documentation path " + path + " does not exist");
            }
            if (!path.isDirectory()) {
                throw new RuntimeException("Documentation path " + path + " is not a directory");
            }
            AutomaticDocumentationTemplate template = new AutomaticDocumentationTemplate(workspace);
            template.setRecursive(true);
            try {
                if (softwareSystem == null) {
                    template.addSections(path);
                } else {
                    template.addSections(softwareSystem, path);
                }
                template.addImages(path);
            }
            catch (IOException e) {
                throw new RuntimeException("Error importing documentation from " + path.getAbsolutePath() + ": " + e.getMessage());
            }
        }
    }
}

