/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.dsl;

import com.structurizr.dsl.AbstractParser;
import com.structurizr.dsl.DynamicViewDslContext;
import com.structurizr.dsl.ExplicitRelationshipParser;
import com.structurizr.dsl.Tokens;
import com.structurizr.model.Element;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.view.DynamicView;

final class DynamicViewContentParser
extends AbstractParser {
    private static final String GRAMMAR = "<identifier> -> <identifier> [description] [technology]";
    private static final int SOURCE_IDENTIFIER_INDEX = 0;
    private static final int DESTINATION_IDENTIFIER_INDEX = 2;
    private static final int DESCRIPTION_INDEX = 3;
    private static final int TECHNOLOGY_INDEX = 4;

    DynamicViewContentParser() {
    }

    void parseRelationship(DynamicViewDslContext context, Tokens tokens) {
        DynamicView view = context.getView();
        if (tokens.hasMoreThan(4)) {
            throw new RuntimeException("Too many tokens, expected: <identifier> -> <identifier> [description] [technology]");
        }
        if (!tokens.includes(2)) {
            throw new RuntimeException("Expected: <identifier> -> <identifier> [description] [technology]");
        }
        String sourceId = tokens.get(0);
        String destinationId = tokens.get(2);
        Element sourceElement = context.getElement(sourceId);
        if (sourceElement == null) {
            throw new RuntimeException("The source element \"" + sourceId + "\" does not exist");
        }
        if (!(sourceElement instanceof StaticStructureElement)) {
            throw new RuntimeException("The source element \"" + sourceId + "\" should be a static structure element");
        }
        Element destinationElement = context.getElement(destinationId);
        if (destinationElement == null) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" does not exist");
        }
        if (!(destinationElement instanceof StaticStructureElement)) {
            throw new RuntimeException("The destination element \"" + destinationId + "\" should be a static structure element");
        }
        String description = "";
        if (tokens.includes(3)) {
            description = tokens.get(3);
        }
        String technology = "";
        if (tokens.includes(4)) {
            technology = tokens.get(4);
        }
        if (!sourceElement.hasEfferentRelationshipWith(destinationElement) && !destinationElement.hasEfferentRelationshipWith(sourceElement)) {
            new ExplicitRelationshipParser().parse(context, tokens);
        }
        view.add((StaticStructureElement)sourceElement, description, technology, (StaticStructureElement)destinationElement);
    }
}

